<?php

if ( ! defined( 'ABSPATH' ) ) {

    exit; // Exit if accessed directly.

}

if ( ! class_exists( 'CBC_Badge_Product_Type' ) ) {


    class CBC_Badge_Product_Type {


        public function __construct() {

            //add_action( 'plugins_loaded', [ $this, 'define_custom_product_class' ] );
            add_filter( 'product_type_selector', [ $this, 'add_customize_product_type' ] );
            add_filter( 'woocommerce_product_class', [ $this, 'customize_product_class' ], 10, 2 );
            //add_action( 'woocommerce_admin_process_product_object', [ $this, 'set_product_type_on_save' ], 20 );
            add_action( 'save_post_product', [ $this, 'save_product_type_taxonomy' ], 20 );
            add_action( 'init', [ $this, 'ensure_term_exists' ] );
            add_action( 'woocommerce_product_data_panels', [ $this,'custom_product_type_show_price' ]);

        }

        function custom_product_type_show_price() {
                wc_enqueue_js( "     
                    $(document.body).on('woocommerce-product-type-change',function(event,type){
                        if (type=='customize_product') {
                            $('.general_tab').show();
                            $('.pricing').show();         
                        }
                    });      
                " );
                global $product_object;
                if ( $product_object && 'customize_product' === $product_object->get_type() ) {
                    wc_enqueue_js( "
                        $('.general_tab').show();
                        $('.pricing').show();         
                    " );
                }
        }

        public function add_customize_product_type( $types ) {

            $types['customize_product'] = __( 'Customize Product', 'cbc-customize-product' );

            return $types;

        }



        public function customize_product_class( $classname, $product_type ) {

            if ( $product_type === 'customize_product' ) {

                $classname = 'WC_Product_Customize';

            }

            return $classname;

        }



        public function set_product_type_on_save( $product ) {

            if ( isset( $_POST['product-type'] ) && $_POST['product-type'] === 'customize_product' ) {

                $product->set_type( 'customize_product' );

            }

        }



        public function save_product_type_taxonomy( $post_id ) {

            if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {

                return;

            }

            if ( wp_is_post_revision( $post_id ) ) {

                return;

            }



            if ( isset( $_POST['product-type'] ) && $_POST['product-type'] === 'customize_product' ) {

                wp_set_object_terms( $post_id, 'customize_product', 'product_type' );

            }

        }



        public function ensure_term_exists() {

            if ( ! term_exists( 'customize_product', 'product_type' ) ) {

                wp_insert_term( 'Customize Product', 'product_type', [ 'slug' => 'customize_product' ] );

            }

        }

    }

}