<?php 
use Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController;
class Class_cbc_order_metabox {
    public function __construct() {
        // Hook to add the metabox
        add_action( 'add_meta_boxes', [ $this, 'add_custom_order_metabox' ] );
        add_action( 'wp_ajax_download_attachment', [ $this,'serve_attachment_download' ]);
        add_action( 'wp_ajax_nopriv_download_attachment',[ $this, 'serve_attachment_download' ]);

    }

    /**
     * Add the custom metabox to the WooCommerce order edit page
     */
        function serve_attachment_download() {
            if ( empty( $_GET['attachment_id'] ) ) {
                wp_die( 'Missing attachment ID.' );
            }

            $attachment_id = absint( $_GET['attachment_id'] );
            $file_path = get_attached_file( $attachment_id );

            if ( ! file_exists( $file_path ) ) {
                wp_die( 'File not found.' );
            }

            $file_name = basename( $file_path );

            // Set headers for download
            header( 'Content-Description: File Transfer' );
            header( 'Content-Type: application/octet-stream' );
            header( 'Content-Disposition: attachment; filename="' . $file_name . '"' );
            header( 'Expires: 0' );
            header( 'Cache-Control: must-revalidate' );
            header( 'Pragma: public' );
            header( 'Content-Length: ' . filesize( $file_path ) );

            // Clear output buffer and read the file
            flush();
            readfile( $file_path );
            exit;
        }

        public function add_custom_order_metabox() {
            $screen = class_exists( '\Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController' ) && wc_get_container()->get( CustomOrdersTableController::class )->custom_orders_table_usage_is_enabled()
            ? wc_get_page_screen_id( 'shop-order' )
            : 'shop_order';
            add_meta_box(
                'wc_custom_order_metabox', // ID
                __( 'Download Badge image', 'textdomain' ), // Title
                [ $this, 'display_custom_order_metabox' ], // Callback
                $screen, // Post type
                'advanced', // Context (side, normal, advanced)
                'high' // Priority
            );
        }

    /**
     * Display the content of the metabox
     */
        public function display_custom_order_metabox( $object  ) {        // Add a nonce for security   
            
            $order = is_a( $object, 'WP_Post' ) ? wc_get_order( $object->ID ) : $object;          

            if ( $order ) {
                $count = 1; // Initialize a counter for items with custom meta
                echo '<div style="margin-bottom: 16px;">';
                foreach ( $order->get_items() as $item_id => $item ) {
                    // Get the custom meta for this item              
                    $attachment_id = wc_get_order_item_meta( $item_id, '_custom_canvas_image_id', true );
                    if ( ! empty( $attachment_id ) ) {
                        // If the meta exists and is not empty, add it to the result                       
                        $download_url = $this->get_force_download_url( $attachment_id );
                        echo '<a href="' . esc_url( $download_url ) . '" class="button" style="margin-right: 10px; margin-top: 10px;margin-bottom: 10px;">Download File ' . esc_html( $count ) . '</a>';                
                      

                    }
                    $count++;
                }
                echo '</div>';
            }   

        }
    /**
 * Generate a download URL for a media attachment ID
 */
    function get_force_download_url( $attachment_id ) {
        $file_url = wp_get_attachment_url( $attachment_id );

        if ( ! $file_url ) {
            return '';
        }

        // Use admin-ajax.php to serve the download and force download headers
        return admin_url( 'admin-ajax.php?action=download_attachment&attachment_id=' . $attachment_id );
    }



}

// Initialize the class
new Class_cbc_order_metabox();
