<?php 
class Class_cbc_image_uploader {

    private $meta_key_prefix = 'badge_image_';

    private $badge_data = [];

    public function __construct() {
        

        add_action('add_meta_boxes', [$this, 'add_metabox']);
        add_action('save_post_product', [$this, 'save_metabox_data']);
        add_action('admin_footer', [$this, 'enqueue_media_uploader']);
    }

    private function load_badge_data($post_id = null) {
        if (!$post_id) {
            global $post;
            $post_id = $post ? $post->ID : 0;
        }


        $data = get_post_meta($post_id, '_custom_repeater_data', true);

        if (!empty($data) && is_array($data)) {
            return $data;
        }

        return []; // fallback if no data found
    }


    public function add_metabox() {
        global $post;
        if ($post && get_post_type($post) === 'product') {
            $product = wc_get_product($post);
            // print_r($product->get_type());
            // die;
            if ($product && $product->get_type() === 'customize_product') {
                add_meta_box(
                    'badge_images_meta_box',
                    'Badge Finish & Color Uploads',
                    [$this, 'render_metabox'],
                    'product',
                    'normal',
                    'default'
                );
            }
        }
    }

    public function render_metabox_old($post) {
        $this->badge_data = $this->load_badge_data();
        $combinations = $this->get_grouped_combinations();

        foreach ($combinations as $shape => $finishes) {
            echo "<h3 style='margin-top:20px; border-bottom:1px solid #ccc;'>Shape: <strong>{$shape}</strong></h3>";

            foreach ($finishes as $finish => $colors) {
                echo "<h4 style='margin-bottom:5px; padding-left:10px;'>Finish: <strong>{$finish}</strong></h4>";
                echo "<div style='padding-left: 20px; margin-bottom:15px;'>";

                foreach ($colors as $color) {
                    $field_key = sanitize_key("{$this->meta_key_prefix}{$shape}_{$finish}_{$color}");
                    $saved_img_id = get_post_meta($post->ID, $field_key, true);
                    $img_url = $saved_img_id ? wp_get_attachment_image_url($saved_img_id, 'thumbnail') : '';

                    echo "<div style='margin-bottom:10px; display:flex; align-items:center; gap:10px;'>";
                    echo "<div style='width:20px; height:20px; background:{$color}; border:1px solid #ccc;'></div>";
                    echo "<input type='hidden' name='badge_image_fields[{$field_key}]' id='{$field_key}' value='" . esc_attr($saved_img_id) . "' />";
                    echo "<button class='upload_badge_image button' data-target='#{$field_key}'>Upload Image</button>";
                    if ($img_url) {
                        echo "<div class='badge-image-wrapper' style='position:relative; display:inline-block;'>";
                        echo "<img src='{$img_url}' class='uploaded-preview' style='height:60px; border:1px solid #ccc;' />";
                        echo "<button class='remove_badge_image' data-target='#{$field_key}' 
                                    style='position:absolute; top:-8px; right:-8px; background:red; color:white; border:none; border-radius:50%; width:20px; height:20px; cursor:pointer; font-weight:bold; line-height:16px;'>×</button>";
                        echo "</div>";
                    }
                    echo "</div>";
                }

                echo "</div>";
            }
        }
    }

    public function render_metabox($post) {
    $this->badge_data = $this->load_badge_data();
    $combinations = $this->get_grouped_combinations(); // badge_type > shape > finish > [colors]

    foreach ($combinations as $type => $shapes) {
        echo "<h2 style='margin-top:30px; border-bottom:2px solid #000;'>Badge Type: <strong>{$type}</strong></h2>";

        foreach ($shapes as $shape => $finishes) {
            echo "<h3 style='margin-top:20px; border-bottom:1px solid #ccc;'>Shape: <strong>{$shape}</strong></h3>";

            foreach ($finishes as $finish => $colors) {
                echo "<h4 style='margin-bottom:5px; padding-left:10px;'>Finish: <strong>{$finish}</strong></h4>";
                echo "<div style='padding-left: 20px; margin-bottom:15px;'>";

                foreach ($colors as $color) {
                    // Unique field key with type included
                    $field_key = sanitize_key("{$this->meta_key_prefix}{$type}_{$shape}_{$finish}_{$color}");
                    $saved_img_id = get_post_meta($post->ID, $field_key, true);
                    $img_url = $saved_img_id ? wp_get_attachment_image_url($saved_img_id, 'thumbnail') : '';

                    echo "<div style='margin-bottom:10px; display:flex; align-items:center; gap:10px;'>";
                    echo "<div style='width:20px; height:20px; background:{$color}; border:1px solid #ccc;'></div>";
                    echo "<input type='hidden' name='badge_image_fields[{$field_key}]' id='{$field_key}' value='" . esc_attr($saved_img_id) . "' />";
                    echo "<button class='upload_badge_image button' data-target='#{$field_key}'>Upload Image</button>";

                    if ($img_url) {
                        echo "<div class='badge-image-wrapper' style='position:relative; display:inline-block;'>";
                        echo "<img src='{$img_url}' class='uploaded-preview' style='height:60px; border:1px solid #ccc;' />";
                        echo "<button class='remove_badge_image' data-target='#{$field_key}' 
                                style='position:absolute; top:-8px; right:-8px; background:red; color:white; border:none; border-radius:50%; width:20px; height:20px; cursor:pointer; font-weight:bold; line-height:16px;'>×</button>";
                        echo "</div>";
                    }

                    echo "</div>";
                }

                echo "</div>"; // .finish section
            }

        } // end shapes
    } // end types
}



    private function get_grouped_combinations() {
    $result = [];

    foreach ($this->badge_data as $item) {
        $type   = $item['badge_type'];
        $shape  = $item['badge_shapes'];
        $finish = $item['badge_finishes'];
        $colors = $item['badge_colors'];

        // Ensure it's an array before looping
        if (!is_array($colors)) {
            $colors = [$colors];
        }

        foreach ($colors as $color) {
            $result[$type][$shape][$finish][$color] = true;
        }
    }

    // Flatten color keys to arrays
    foreach ($result as $type => $shapes) {
        foreach ($shapes as $shape => $finishes) {
            foreach ($finishes as $finish => $colors) {
                $result[$type][$shape][$finish] = array_keys($colors);
            }
        }
    }

    return $result;
}



    private function get_unique_combinations_old() {
        $result = [];
        foreach ($this->badge_data as $item) {
            $finish = $item['badge_finishes'];
            foreach ($item['badge_colors'] as $color) {
                $result[$finish][$color] = true;
            }
        }

        // Convert keys back to array
        foreach ($result as $finish => $colors) {
            $result[$finish] = array_keys($colors);
        }

        return $result;
    }

    private function get_unique_combinations() {
            $result = [];

            foreach ($this->badge_data as $item) {
                $type    = $item['badge_type'];
                $size    = $item['badge_sizes'];
                $finish  = $item['badge_finishes'];
                $colors  = $item['badge_colors'];

                if (!is_array($colors)) {
                    $colors = [$colors];
                }

                foreach ($colors as $color) {
                    $result[$type][$size][$finish][$color] = true;
                }
            }

            // Convert colors from keys to array values
            foreach ($result as $type => $sizes) {
                foreach ($sizes as $size => $finishes) {
                    foreach ($finishes as $finish => $colors) {
                        $result[$type][$size][$finish] = array_keys($colors);
                    }
                }
            }

            return $result;
    }


    public function save_metabox_data($post_id) {
         $image_data = [];
            if (isset($_POST['badge_image_fields']) && is_array($_POST['badge_image_fields'])) {
                foreach ($_POST['badge_image_fields'] as $field => $img_id) {
                    update_post_meta($post_id, sanitize_key($field), intval($img_id));
                    $sanitized_field = sanitize_key($field);
                    $image_url = wp_get_attachment_url(intval($img_id));
                    $image_data[$sanitized_field] = esc_url_raw($image_url);
                }

                update_post_meta($post_id, '_badge_image_map', $image_data);
            }
    }

    public function enqueue_media_uploader() {
    global $post;
    if (!$post || get_post_type($post) !== 'product') return;
    $product = wc_get_product($post);
    if (!$product || $product->get_type() !== 'customize_product') return;

    ?>
<script>
jQuery(document).ready(function($) {
    var file_frame;

    // Upload button handler
    $('.upload_badge_image').on('click', function(e) {
        e.preventDefault();
        var button = $(this);
        var target = $(button.data('target'));

        if (file_frame) file_frame.close();

        file_frame = wp.media({
            title: 'Select or Upload Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        });

        file_frame.on('select', function() {
            var attachment = file_frame.state().get('selection').first().toJSON();
            target.val(attachment.id);

            const wrapper = button.closest('div');
            wrapper.find('.uploaded-preview').remove();
            wrapper.find('.remove_badge_image').remove();

            button.after(
                '<div class="badge-image-wrapper" style="position:relative; display:inline-block;">' +
                '<img src="' + attachment.sizes.thumbnail.url +
                '" style="height:60px; border:1px solid #ccc;" class="uploaded-preview" />' +
                '<button class="remove_badge_image" data-target="#' + target.attr('id') +
                '" style="position:absolute; top:-8px; right:-8px; background:red; color:white; border:none; border-radius:50%; width:20px; height:20px; cursor:pointer; font-weight:bold; line-height:16px;">×</button>' +
                '</div>');
        });

        file_frame.open();
    });

    // Remove button handler
    $(document).on('click', '.remove_badge_image', function(e) {
        e.preventDefault();
        const btn = $(this);
        const target = $(btn.data('target'));

        target.val('');
        btn.siblings('.uploaded-preview').remove();
        btn.remove();
    });
});
</script>
<?php
}


    public function enqueue_media_uploader_old() {
        global $post;
        if (!$post || get_post_type($post) !== 'product') return;
        $product = wc_get_product($post);
        if (!$product || $product->get_type() !== 'customize_product') return;

        ?>
<script>
jQuery(document).ready(function($) {
    var file_frame;

    $('.upload_badge_image').on('click', function(e) {
        e.preventDefault();
        var button = $(this);
        var target = $(button.data('target'));

        if (file_frame) file_frame.close();

        file_frame = wp.media({
            title: 'Select or Upload Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        });

        file_frame.on('select', function() {
            var attachment = file_frame.state().get('selection').first().toJSON();
            target.val(attachment.id);
            button.siblings('img').remove();
            button.after('<img src="' + attachment.sizes.thumbnail.url +
                '" style="height:40px;" />');
        });

        file_frame.open();
    });
});
</script>
<?php
    }
}

new Class_cbc_image_uploader();