jQuery(document).ready(function ($) {
  /**/

  /**/
  $("#scroll_btn").on("click", function (e) {
    e.preventDefault(); // Prevent default jump
    var target = $(this).attr("href"); // Get href value
    var $target = $(target);
    if ($target.length) {
      $("html, body").animate(
        {
          scrollTop: $target.offset().top,
        },
        1000
      ); // Adjust scroll speed (800ms)
    }
  });

  if (typeof badgeShapeImages !== "undefined") {
    if (badgeShapeImages.ovalImage) {
      console.log("Oval image:", badgeShapeImages.ovalImage);
      // Example: document.getElementById('canvas').src = badgeShapeImages.ovalImage;
    }

    if (badgeShapeImages.rectangleImage) {
      console.log("Rectangle image:", badgeShapeImages.rectangleImage);
    }
  }

  let currentTextObj = null;
  const canvas = new fabric.Canvas("badgeCanvas");
  // Set this after initialization

  /*new variable*/
  let badgeWidth = 300;
  let badgeHeight = 100;
  let userImage = null;
  // Create the initial badge shape
  let badgeShape;
  const data = JSON.parse($("#badgeData").html());
  // const badgeImageMap = JSON.parse($('#badgeImage').html());

  let badgeImageMap = {};
  if ($("#badgeImage").length) {
    try {
      badgeImageMap = JSON.parse($("#badgeImage").html() || "{}");
    } catch (e) {
      console.error("Invalid JSON in #badgeImage:", e);
      badgeImageMap = {};
    }
  }
  const badge_colors = JSON.parse($("#badge_colors").html());
  const badge_price = JSON.parse($("#badgePrice").html());
  const container = $("<div>", {
    class: "formouterrow",
  });

  // Hidden field for the selected SKU
  const selectedSkuInput = $("<input>", {
    type: "hidden",
    name: "badge_sku",
    id: "badge_sku",
  });
  container.append(selectedSkuInput);
  // Progress bar
  // const progressInner = $("<div>", {
  //   class: "progress-inner",
  // }).append(
  //   $("<div>", {
  //     class: "step-indicator active badge_type",
  //     text: "Badge Type",
  //   }),
  //   $("<div>", {
  //     class: "step-indicator badge_shape",
  //     text: "Badge Shape",
  //   }),
  //   $("<div>", {
  //     class: "step-indicator badge_size",
  //     text: "Size",
  //   }),
  //   $("<div>", {
  //     class: "step-indicator badge_upload_image",
  //     text: "Upload your image",
  //   }),
  //   $("<div>", {
  //     class: "step-indicator badge_add_text",
  //     text: "Add Texts",
  //   }),
  //   $("<div>", {
  //     class: "step-indicator badge_thickness",
  //     text: "Thickness",
  //   }),
  //   $("<div>", {
  //     class: "step-indicator badge_finish",
  //     text: "Finish",
  //   }),
  //   $("<div>", {
  //     class: "step-indicator badge_color",
  //     text: "Color",
  //   }),
  //   $("<div>", {
  //     class: "step-indicator badge_corners",
  //     text: "Corners",
  //   }),
  //   $("<div>", {
  //     class: "step-indicator badge_backing",
  //     text: "Backing",
  //   })
  // );
  // container.append(progressInner);

    const stepLabels = {
        badge_type: "Badge Type",
        badge_shapes: "Badge Shape",
        badge_sizes: "Size",
        badge_upload_image: "Upload your image", // Assume this is conditionally added elsewhere
        badge_add_text: "Add Texts",              // Same assumption
        badge_thicknesses: "Thickness",
        badge_finishes: "Finish",
        badge_colors: "Color",
        badge_corners: "Corners",
        badge_backings: "Backing"
  };

// Step keys in the desired order
const stepOrder = [
  "badge_type",
  "badge_shapes",
  "badge_sizes",
  "badge_upload_image",  // Optional, based on your logic
  "badge_add_text",      // Optional
  "badge_thicknesses",
  "badge_finishes",
  "badge_colors",
  "badge_corners",
  "badge_backings"
];



// Build the progress bar


let firstStepAdded = false;

// Build which steps should be shown
const availableSteps = {};
stepOrder.forEach((key) => {
  // Always include upload and add_text steps
  if (key === "badge_upload_image" || key === "badge_add_text") {
    availableSteps[key] = true;
  } else {
    // For other steps, check if any badge entry has valid data
    availableSteps[key] = data.some((item) => {
      const value = item[key];
      if (Array.isArray(value)) return value.length > 0;
      return value !== undefined && value !== null && value !== "" && value !== false;
    });
  }
});

// Build the progress bar
  const progressInner = $("<div>", { class: "progress-inner" });


  stepOrder.forEach((key) => {
    if (availableSteps[key]) {
      const stepDiv = $("<div>", {
        class: `step-indicator ${key}` + (!firstStepAdded ? " active" : ""),
        text: stepLabels[key] || key,
      });
      progressInner.append(stepDiv);
      firstStepAdded = true;
    }
  });

  container.append(progressInner);
  function setupCustomRotate() {
    // Apply globally for all fabric objects
    fabric.Object.prototype.controls.mtr = new fabric.Control({
      x: 0,
      y: -0.5,
      offsetY: -40,
      cursorStyle: "crosshair",
      actionHandler: fabric.controlsUtils.rotationWithSnapping,
      actionName: "rotate",
      render: renderCustomRotateIcon,
      cornerSize: 24,
    });

    // OPTIONAL: Force update of all existing objects (like textbox) if already added
    canvas.getObjects().forEach((obj) => {
      obj.setControlsVisibility({
        mtr: true, // ensure rotate is visible
      });
    });

    canvas.requestRenderAll();
  }

  // Helper functions (same as before)
  function createRadioOptions(
    name,
    options,
    className = "radio-checkbox-inner elem-2"
  ) {
    return $("<div>", {
      class: className,
    }).append(
      options.map((opt, index) => {
        if (!opt || opt.trim() === "") return "";
        const id = name + (index + 1);
        return $("<label>", {
          for: id,
        }).append(
          $("<input>", {
            type: "radio",
            name: name,
            value: opt,
            id: id,
          }),
          $("<span>", {
            text: opt,
          })
        );
      })
    );
  }

  function createRadioOptionsWithPrice(
    name,
    options,
    className = "radio-checkbox-inner elem-2"
  ) {
    return $("<div>", {
      class: className,
    }).append(
      options.map((opt, index) => {
        if (!opt || typeof opt.label !== "string") return "";

        const id = name + (index + 1);
        const label = opt.label.trim();
        let displayPrice = "included";
        let dataPrice = "0.00";

        if (opt.price && parseFloat(opt.price) > 0) {
          dataPrice = parseFloat(opt.price).toFixed(2);
          displayPrice = `${productCustomizerData.currencySymbol}${dataPrice}`;
        }

        return $("<label>", {
          for: id,
        }).append(
          $("<input>", {
            type: "radio",
            name: name,
            id: id,
            value: label,
            "data-price": dataPrice,
          }),
          $("<span>").append(
            $("<span>", {
              text: label,
            }),
            " ",
            $("<span>", {
              class: "price-text",
              text: `(${displayPrice})`,
            })
          )
        );
      })
    );
  }

  function createRadioOptionsWithPrice_old(
    name,
    options,
    className = "radio-checkbox-inner elem-2"
  ) {
    return $("<div>", {
      class: className,
    }).append(
      options.map((opt, index) => {
        if (!opt || typeof opt.label !== "string") return "";

        const id = name + (index + 1);
        const label = opt.label;
        const price = opt.price || "included"; // can be string like "included" or a number

        return $("<label>", {
          for: id,
        }).append(
          $("<input>", {
            type: "radio",
            name: name,
            id: id,
            value: label,
            "data-price": price,
          }),
          $("<span>").append(
            $("<span>", {
              text: label,
            }),
            " ",
            $("<span>", {
              class: "price-text",
              text: `(${price})`,
            })
          )
        );
      })
    );
  }

  function createRadioOptionsWithImages(
    name,
    options,
    assetUrl,
    extension = "svg"
  ) {
    return $("<div>", {
      class: "radio-checkbox-inner elem-2",
    }).append(
      options.map((opt) => {
        const imageSrc = `${assetUrl}/${opt}.${extension}`;
        return $("<label>").append(
          $("<img>", {
            src: imageSrc,
            alt: opt,
            width: 100,
          }),
          $("<input>", {
            type: "radio",
            name: name,
            value: opt,
          }),
          $("<span>")
        );
      })
    );
  }

//   // Get unique types for Step 1
// const types = [...new Set(data.map((item) => item.badge_type))];

// // Step 1: Type selection
// const step1 = $("<div>", {
//   class: "step active", // Step 1 starts as active
// }).append(
//   $("<div>", {
//     class: "innerstep",
//   }).append("<div>", {
//     class: "option-wrapper",
//   }).append(
//     createRadioOptions(
//       "badge_type",               // input name
//       types,                      // values from badge_types
//       "radio-checkbox-inner radiobx" // css class
//     ),
//     $("<div>", {
//       class: "buttons singlebtn",
//     }).append(
//       $("<button>", {
//         type: "button",
//         class: "next green-btn",
//         html: "Next",
//       })
//     )
//   )
// );
const step1 ='';
  // Get unique types from data
const types = [...new Set(data.map((item) => item.badge_type).filter(Boolean))];

console.log("types"+types);
let hasStep1 = types.length > 0;
console.log("hasStep1"+hasStep1)

if (hasStep1) {

  console.log('step1 inner')

  // Step 1: Type selection
   const step1 = $("<div>", {
    class: "step active", // Step 1 starts as active if it's the first step
  }).append(
    $("<div>", {
      class: "innerstep",
    }).append(
      $("<div>", {
        class: "option-wrapper",
      }).append(
        createRadioOptions(
          "badge_type",               // input name
          types,                      // values from badge_types
          "radio-checkbox-inner radiobx" // css class
        )
      ),
      $("<div>", {
        class: "buttons singlebtn",
      }).append(
        $("<button>", {
          type: "button",
          class: "next green-btn",
          html: "Next",
        })
      )
    )
  );
   container.append(step1);
  // Append step1 to your step container
  //$("#multiStepForm").append(step1); // Replace with your container
}


  // Get unique shapes
  const shapes = [...new Set(data.map((item) => item.badge_shapes))];

    // Step 2: Shape selection
const step2 = $("<div>", {
  class:  "step_two step" + (!hasStep1 ? " active" : ""),
}).append(
  $("<div>", {
    class: "innerstep",
  }).append(
    $("<div>", {
      class: "option-wrapper",
    }).append(
      // Wrap the output of createRadioOptionsWithImages inside another div
      $("<div>", {
        class: "options-container", // new wrapper div
      }).append(
        createRadioOptionsWithImages(
          "badge_shape",
          shapes,
          productCustomizerData.pluginUrl + "images"
        )
      )
    ),
    $("<div>", {
      class: "buttons",
    }).append(
      $("<button>", {
        type: "button",
        class: "prev green-btn",
        html: "Prev",
      }),
      $("<button>", {
        type: "button",
        class: "next green-btn",
        html: "Next",
      })
    )
  )
);


  // Step 3: Upload your image (always included!)
  const step4 = $("<div>", {
    class: "step",
  }).append(
    $("<div>", {
      class: "innerstep",
    }).append("<div>", {
      class: "option-wrapper",
    }).append(
      $("<div>", { class: "fileupload" }).append(
        $("<section>", { class: "minimal-file-uploader" }).append(
          $("<h5>", { text: "Upload Your File" }),
          // Uploader controls
          $("<div>", { class: "uploader-controls" }).append(
            $("<input>", {
              type: "file",
              id: "imgLoader",
              name: "original_image",
              style: "display: none;",
            }),
            $("<button>", {
              type: "button",
              class: "browse-btn green-btn",
              id: "selectFileBtn",
              text: "Choose File",
            })
          ),

          // File name display
          $("<span>", {
            class: "file-name",
            id: "fileNameDisplay",
            text: "No file selected",
          }),

         
          $("<div>", {
            class: "zoom-controls d-none",
            style: "margin-top:10px;",
          }).append(
            $("<button>", {
              type: "button",
              class: "zoom-btn",
              id: "zoomInBtn",
            }).append(
              $("<i>", { class: "fas fa-magnifying-glass-plus" }) // Font Awesome icon for zoom in
            ),
            $("<button>", {
              type: "button",
              class: "zoom-btn",
              id: "zoomOutBtn",
              style: "margin-left: 10px;",
            }).append(
              $("<i>", { class: "fas fa-magnifying-glass-minus" }) // Font Awesome icon for zoom out
            )
          )
        )
      ),
      $("<div>", {
        class: "buttons",
      }).append(
        $("<button>", {
          type: "button",
          class: "prev green-btn",
          html: "Prev",
        }),
        $("<button>", {
          type: "button",
          class: "next green-btn",
          html: "Next",
        })
      )
    )
  );

  const step5 = $("<div>", {
    class: "step",
  }).append(
    $("<div>", {
      class: "innerstep",
    }).append("<div>", {
    class: "option-wrapper",
  }).append(
      $("<div>", { class: "text-options" }).append(
        $("<h5>", { text: "Add Text to Your Design" }),

        // Textarea input
        $("<div>", { class: "form-group" }).append(
          $("<label>", { for: "textInput", text: "Text:" }),
          $("<textarea>", {
            id: "textInput",
            rows: 3,
            class: "form-control",
            placeholder: "Enter your text here...",
          })
        ),

        // Text size input
        $("<div>", { class: "form-group" }).append(
          $("<label>", {
            for: "textSize",
            text: "Text Size:",
            class: "form-label",
          }),
          $("<input>", {
            type: "range",
            id: "textSize",
            min: 10,
            max: 100,
            value: 24,
          }),
          $("<span>", {
            id: "textSizeDisplay",
            text: "24px",
          }),
          $("<input>", {
            type: "hidden",
            id: "textSizeChange",
            value: "0",
          })
        ),

        // Text color input
        $("<div>", { class: "form-group" }).append(
          $("<label>", {
            for: "textColor",
            text: "Text Color:",
            class: "form-label",
          }),
          $("<input>", {
            type: "color",
            class: "form-color",
            id: "textColor",
            value: "#000000",
          }),

          $("<input>", {
            type: "hidden",
            id: "textColorChange",
            value: "0",
          })
        ),

      

        $("<div>", { class: "form-group" }).append(
          $("<label>", {
              for: "textFont",
              text: "Font Family:",
              class: "form-label"
          }),
          (function () {
              const select = $("<select>", { id: "textFont",class:"form-select" }).append(
                  $("<option>", { value: "", text: "Select" }),
                  $("<option>", { value: "Arial", text: "Arial" }),
              );

              if (typeof CBCFonts !== 'undefined' && Array.isArray(CBCFonts.fonts)) {
                  CBCFonts.fonts.forEach(function (font) {
                      select.append($("<option>", {
                          value: font,
                          text: font
                      }));
                  });
              }

              return(select) ;
          })()
      )

      ),

      // Navigation buttons
      $("<div>", {
        class: "buttons",
      }).append(
        $("<button>", {
          type: "button",
          class: "prev green-btn",
          html: "Prev",
        }),
        $("<button>", {
          type: "button",
          class: "next green-btn",
          html: "Next",
        })
      )
    )
  );

  const step3 = $("<div>", {
    class: "step",
  });
  const step6 = $("<div>", {
    class: "step",
  });
  const step7 = $("<div>", {
    class: "step",
  });
  const step8 = $("<div>", {
    class: "step",
  });
  const step9 = $("<div>", {
    class: "step",
  });
  const step10 = $("<div>", {
    class: "step",
  });

  container.append(
    step1,
    step2,
    step3,
    step4,
    step5,
    step6,
    step7,
    step8,
    step9,
    step10
  );
  //$('#badgeTabsContainer').append(container);

  function updateOptions_with_out_type(selectedShape, selectedFinish = null) {
    //  console.log('selected shape'+selectedShape);
    //  console.log('selected Finish'+selectedFinish);
    const filteredData = data.filter(
      (item) => item.badge_shapes === selectedShape
    );
    const sizes = [...new Set(filteredData.map((item) => item.badge_sizes))];
    const thicknesses = [
      ...new Set(filteredData.map((item) => item.badge_thicknesses)),
    ];
    const finishes = [
      ...new Set(filteredData.map((item) => item.badge_finishes)),
    ];
    const corners = [
      ...new Set(filteredData.flatMap((item) => item.badge_corners || [])),
    ];
    //const backings = [...new Set(filteredData.map(item => item.badge_backings))];
    // Update steps based on filtered data
    const backings = [
      ...new Set(
        filteredData
          .filter(
            (item) => item.badge_backings && item.badge_backings.trim() !== ""
          )
          .map((item) => {
            const label = item.badge_backings.trim();
            let price = item.backing_price;

            if (price === "0.00" || price === 0 || parseFloat(price) === 0) {
              price = "included";
            } else {
              price = `${parseFloat(price).toFixed(2)}`;
            }

            return JSON.stringify({
              label,
              price,
            });
          })
      ),
    ].map((str) => JSON.parse(str));

    //steps

    step3.html("").append(
      $("<div>", {
        class: "innerstep",
      }).append("<div>", {
    class: "option-wrapper",
  }).append(
        createRadioOptions("badge_size", sizes, "radio-checkbox-inner radiobx"),
        createNavButtons()
      )
    );

    step6.html("").append(
      $("<div>", {
        class: "innerstep",
      }).append(
        createRadioOptions(
          "badge_thickness",
          thicknesses,
          "radio-checkbox-inner radiobx"
        ),
        createNavButtons()
      )
    );

    // console.log("finishes line"+finishes);

    //    console.log("finishes length"+finishes.length);

    if (Array.isArray(finishes) && finishes.length) {
      // console.log('finishes'+finishes);
      // alert('line 366'+finishes.length);
      $(".step-indicator.badge_finish").removeClass("d-none");
      step7.html("");
      step7.removeClass("not_required d-none").append(
        $("<div>", {
          class: "innerstep",
        }).append(
          createRadioOptions(
            "badge_finish",
            finishes,
            "radio-checkbox-inner radiobx"
          ),
          createNavButtons()
        )
      );
    } else {
      //alert('else 376');
      $(".step-indicator.badge_finish").addClass("d-none");
      step7.addClass("not_required d-none").html("");

      updateColorsWithOutFinish(selectedShape, (selectedFinish = false));
    }

    // If selectedFinish is not provided, skip updating step6
    // if (selectedFinish) {
    //     updateColors(selectedShape, selectedFinish);
    // }

    if (Array.isArray(corners) && corners.length > 0) {
      $(".step-indicator.badge_corners").removeClass("d-none");
      step9
        .html("")
        .removeClass("not_required d-none")
        .append(
          $("<div>", {
            class: "innerstep",
          }).append(
            createRadioOptions(
              "badge_corners",
              corners,
              "radio-checkbox-inner radiobx"
            ),
            createNavButtons()
          )
        );
    } else {
      $(".step-indicator.badge_corners").addClass("d-none");
      step9.addClass("not_required d-none").html(""); // optionally clear or leave it untouched
    }

    //  console.log("line 278" + backings);
    step10.html("").append(
      $("<div>", {
        class: "innerstep",
      }).append(
        createRadioOptionsWithPrice(
          "badge_backing",
          backings,
          "radio-checkbox-inner radiobx badge_backing_rdo"
        ),
        $("<div>", {
          class: "buttons",
        }).append(
          $("<button>", {
            type: "button",
            class: "prev green-btn",
            html: "Prev",
          }),
          $("<button>", {
            type: "button",
            class: "downloadCanvas download-btn green-btn",
            html: "Download",
          })
        )
      )
    );
  }


  /*update option new start*/

  function updateOptions(selectedType, selectedShape, selectedFinish = null) {
  // Filter data by badge_type and badge_shape
  const filteredData = data.filter(
    (item) => item.badge_type === selectedType && item.badge_shapes === selectedShape
  );

  const sizes = [...new Set(filteredData.map((item) => item.badge_sizes))];
  // alert("selectedType"+selectedType)
  // alert(sizes);
  const thicknesses = [...new Set(filteredData.map((item) => item.badge_thicknesses))];
  const finishes = [...new Set(filteredData.map((item) => item.badge_finishes))];
  const corners = [...new Set(filteredData.flatMap((item) => item.badge_corners || []))];

  const backings = [
    ...new Set(
      filteredData
        .filter((item) => item.badge_backings && item.badge_backings.trim() !== "")
        .map((item) => {
          const label = item.badge_backings.trim();
          let price = item.backing_price;

          if (price === "0.00" || price === 0 || parseFloat(price) === 0) {
            price = "included";
          } else {
            price = `${parseFloat(price).toFixed(2)}`;
          }

          return JSON.stringify({ label, price });
        })
    ),
  ].map((str) => JSON.parse(str));

  // STEP 3 – Badge Sizes
  step3.html("").append(
    $("<div>", { class: "innerstep" }).append(
      $("<div>", { class: "option-wrapper" }).append(
        $("<div>", { class: "options-container" }).append(
          createRadioOptions("badge_size", sizes, "radio-checkbox-inner radiobx")
        )
      ),
      createNavButtons()
    )
  );

  // STEP 6 – Badge Thickness
  step6.html("").append(
    $("<div>", { class: "innerstep" }).append(
      $("<div>", { class: "option-wrapper" }).append(
        $("<div>", { class: "options-container" }).append(
          createRadioOptions("badge_thickness", thicknesses, "radio-checkbox-inner radiobx")
        )
      ),
      createNavButtons()
    )
  );

  // STEP 7 – Badge Finish
  if (Array.isArray(finishes) && finishes.length) {
    $(".step-indicator.badge_finish").removeClass("d-none");
    step7.html("").removeClass("not_required d-none").append(
      $("<div>", { class: "innerstep" }).append(
        $("<div>", { class: "option-wrapper" }).append(
          $("<div>", { class: "options-container" }).append(
            createRadioOptions("badge_finish", finishes, "radio-checkbox-inner radiobx")
          )
        ),
        createNavButtons()
      )
    );
  } else {
    $(".step-indicator.badge_finish").addClass("d-none");
    step7.addClass("not_required d-none").html("");
    updateColorsWithOutFinish(selectedShape, false); // No finish means update differently
  }

  // STEP 9 – Badge Corners
  if (Array.isArray(corners) && corners.length > 0) {
    $(".step-indicator.badge_corners").removeClass("d-none");
    step9.html("").removeClass("not_required d-none").append(
      $("<div>", { class: "innerstep" }).append(
        $("<div>", { class: "option-wrapper" }).append(
          $("<div>", { class: "options-container" }).append(
            createRadioOptions("badge_corners", corners, "radio-checkbox-inner radiobx")
          )
        ),
        createNavButtons()
      )
    );
  } else {
    $(".step-indicator.badge_corners").addClass("d-none");
    step9.addClass("not_required d-none").html("");
  }

  // STEP 10 – Badge Backings
  step10.html("").append(
    $("<div>", { class: "innerstep" }).append(
      $("<div>", { class: "option-wrapper" }).append(
        $("<div>", { class: "options-container" }).append(
          createRadioOptionsWithPrice(
            "badge_backing",
            backings,
            "radio-checkbox-inner radiobx badge_backing_rdo"
          )
        )
      ),
      $("<div>", { class: "buttons" }).append(
        $("<button>", {
          type: "button",
          class: "prev green-btn",
          html: "Prev",
        }),
        $("<button>", {
          type: "button",
          class: "downloadCanvas download-btn green-btn",
          html: "Download",
        })
      )
    )
  );
}


  /*update option new end*/

  function updateColors_24_06_2025(selectedShape, selectedFinish) {
     //alert('line 431')
    // Filter data based on shape and finish
    const colorFilteredData = data.filter(
      (item) =>
        item.badge_shapes === selectedShape &&
        item.badge_finishes === selectedFinish
    );

    const colors = [
      ...new Set(colorFilteredData.flatMap((item) => item.badge_colors)),
    ];

    const colorBoxes = colors.map((color) => {
      const colorObj = badge_colors.find((badge) => badge.code === color);
      const colorName = colorObj ? colorObj.name : "Unknown";

      return $("<label>", {
        class: "radio_color",
      }).append(
        $("<div>", {
          class: "color-box",
          style: `background-color:${color}; width:30px; height:30px; display:inline-block; margin:3px;`,
        }),
        $("<input>", {
          type: "radio",
          name: "badge_color",
          value: color,
          autocomplete: "off",
        }),
        $("<span>", {
          title: colorName,
          "data-color": color,
        }).text(colorName)
      );
    });
    step8.html("");
    step8.html("").append(
      $("<div>", {
        class: "innerstep line464",
      }).append(
        $("<div>", {
          class: "radio-checkbox-inner radiobx colorbx",
        }).append(colorBoxes),
        createNavButtons()
      )
    );
  }
  function updateColors(selectedShape, selectedFinish, selectedType = null) {
  // Filter data based on shape, finish, and optionally type
  const colorFilteredData = data.filter((item) => {
    const shapeMatch = item.badge_shapes === selectedShape;
    const finishMatch = item.badge_finishes === selectedFinish;
    const typeMatch = selectedType
      ? item.badge_type && item.badge_type === selectedType
      : true; // Ignore type match if selectedType is null
    return shapeMatch && finishMatch && typeMatch;
  });

  const colors = [
    ...new Set(colorFilteredData.flatMap((item) => item.badge_colors)),
  ];

  const colorBoxes = colors.map((color) => {
    const colorObj = badge_colors.find((badge) => badge.code === color);
    const colorName = colorObj ? colorObj.name : "Unknown";

    return $("<label>", {
      class: "radio_color",
    }).append(
      $("<div>", {
        class: "color-box",
        style: `background-color:${color}; width:30px; height:30px; display:inline-block; margin:3px;`,
      }),
      $("<input>", {
        type: "radio",
        name: "badge_color",
        value: color,
        autocomplete: "off",
      }),
      $("<span>", {
        title: colorName,
        "data-color": color,
      }).text(colorName)
    );
  });

  step8.empty().append(
    $("<div>", {
      class: "innerstep line464",
    }).append(
      $("<div>", {
        class: "radio-checkbox-inner radiobx colorbx",
      }).append(colorBoxes),
      createNavButtons()
    )
  );
}


  function updateColorsWithOutFinish(selectedShape, selectedFinish) {
    // Filter logic
    //alert('line 477')
    const colorFilteredData = data.filter((item) => {
      return (
        item.badge_shapes === selectedShape &&
        (selectedFinish ? item.badge_finishes === selectedFinish : true)
      );
    });

    // Extract unique colors
    const colors = [
      ...new Set(colorFilteredData.flatMap((item) => item.badge_colors)),
    ];

    // If no colors found, clear step
    if (!colors.length) {
      step6.html("");
      return;
    }

    // Build radio color boxes
    const colorBoxes = colors.map((color) => {
      const colorObj = badge_colors.find((badge) => badge.code === color);
      const colorName = colorObj ? colorObj.name : "Unknown";

      return $("<label>", {
        class: "radio_color",
      }).append(
        $("<div>", {
          class: "color-box",
          style: `background-color:${color}; width:30px; height:30px; display:inline-block; margin:3px;`,
        }),
        $("<input>", {
          type: "radio",
          name: "badge_color",
          value: color,
          autocomplete: "off",
        }),
        $("<span>", {
          title: colorName,
          "data-color": color,
        }).text(colorName)
      );
    });

    // Render to step6
    step8.html("").append(
      $("<div>", { class: "innerstep line517" }).append(
        $("<div>", {
          class: "radio-checkbox-inner radiobx colorbx",
        }).append(colorBoxes),
        createNavButtons()
      )
    );
  }

  // Utility for creating navigation buttons
  function createNavButtons() {
    return $("<div>", {
      class: "buttons",
    }).append(
      $("<button>", {
        type: "button",
        class: "prev green-btn",
        html: "Prev",
      }),
      $("<button>", {
        type: "button",
        class: "next green-btn",
        html: "Next",
      })
    );
  }
  if ($('input[name="badge_type"]').length) {
     $(document).on("change", 'input[name="badge_type"]', function () {
        const selectedType = $(this).val();
        const matchedItems = data.filter((item) => item.badge_type === selectedType);
        if (matchedItems.length > 0) {
          const firstMatch = matchedItems[0];
          const firstShape = firstMatch.badge_shapes;
          const firstSize = firstMatch.badge_sizes;
          // Update options and UI
          updateOptions(selectedType, firstShape);
          // Auto-select shape and size after DOM is updated
          setTimeout(() => {
            $(`input[name="badge_shape"]`).filter(function () {
              return $(this).val() === firstShape;
            }).prop("checked", true).trigger('change');

            $(`input[name="badge_size"]`).filter(function () {
              return $(this).val() === firstSize;
            }).prop("checked", true).trigger('change');
          }, 2); // short delay to ensure radios are rendered
        }
    });
  }


  // $(document).on("change", 'input[name="badge_shape"]', function () {
  //   // canvas.clear(); // Clear existing shapes
  //   const selectedType = $('input[name="badge_type"]:checked').val();
  //   const selectedShape = $(this).val();

  //   updateOptions(selectedType,selectedShape);
  //   if(selectedType && selectedShape ){

  //     const firstMatch = data.find((item) => item.badge_type === selectedType);
  //       console.log("first shape" + firstMatch.badge_shapes);
  //       console.log("first match badge_sizes" + firstMatch.badge_sizes);
  //       console.log("first match" + firstMatch.badge_finishes);

  //        if (firstMatch) {
  //       // 1️⃣ Set badge size (like you already did)
  //       if (firstMatch.badge_sizes) {
  //         const firstSize = firstMatch.badge_sizes;
  //         const sizeInput = $('input[name="badge_size"]').filter(function () {
  //           return $(this).val() === firstSize;
  //         });

  //         if (sizeInput.length) {
  //           $('input[name="badge_size"]').prop("checked", false); // clear previous
  //           sizeInput.prop("checked", true); // check matching one
  //         }
  //       }

  //       // 2️⃣ Set badge finish (similar logic)
  //       if (firstMatch.badge_finishes) {
  //         const firstFinish = firstMatch.badge_finishes;

  //         //alert(firstFinish);

  //         // const firstFinish = firstMatch.badge_finish;
  //         $(`input[name="badge_finish"][value="${firstFinish}"]`)
  //           .prop("checked", true)
  //           .trigger("change");
  //       }
  //     }

  //     canvas.clear(); // new line added 11-06-2025     
  //   }    
   
  // });

    function updateOptionsWithOutType(selectedShape, selectedFinish = null) {
        console.log('selected shape'+selectedShape);
        console.log('selected Finish'+selectedFinish);
        const filteredData = data.filter(item => item.badge_shapes === selectedShape);
        const sizes = [...new Set(filteredData.map(item => item.badge_sizes))];
        const thicknesses = [...new Set(filteredData.map(item => item.badge_thicknesses))];
        const finishes = [...new Set(filteredData.map(item => item.badge_finishes))];
        const corners = [...new Set(filteredData.flatMap(item => item.badge_corners || []))];
        //const backings = [...new Set(filteredData.map(item => item.badge_backings))];
        // Update steps based on filtered data
        const backings = [
            ...new Set(
                filteredData
                .filter(item => item.badge_backings && item.badge_backings.trim() !== "")
                .map(item => {
                    const label = item.badge_backings.trim();
                    let price = item.backing_price;

                    if (price === "0.00" || price === 0 || parseFloat(price) === 0) {
                        price = "included";
                    } else {
                        price = `${parseFloat(price).toFixed(2)}`;
                    }

                    return JSON.stringify({
                        label,
                        price
                    });
                })
            )
        ].map(str => JSON.parse(str));

        //steps

        step3.html('').append(
            $('<div>', {
                class: 'innerstep'
            }).append(
                createRadioOptions('badge_size', sizes, 'radio-checkbox-inner radiobx'),
                createNavButtons()
            )
        );

        step5.html('').append(
            $('<div>', {
                class: 'innerstep'
            }).append(
                createRadioOptions('badge_thickness', thicknesses, 'radio-checkbox-inner radiobx'),
                createNavButtons()
            )
        );

        console.log("finishes line"+finishes);

        console.log("finishes length"+finishes.length);

        if (Array.isArray(finishes) && finishes.length) {
            // console.log('finishes'+finishes);
            // alert('line 366'+finishes.length);
             $('.step-indicator.badge_finish').removeClass('d-none');
            step6.html(''); 
            step6.removeClass('not_required d-none').append(
                $('<div>', {
                    class: 'innerstep'
                }).append(
                    createRadioOptions('badge_finish', finishes, 'radio-checkbox-inner radiobx'),
                    createNavButtons()
                )
            );
        }else{
            //alert('else 376');
            $('.step-indicator.badge_finish').addClass('d-none');
            step6.addClass('not_required d-none').html(''); 

            updateColorsWithOutFinish(selectedShape, selectedFinish=false);           
        }

        // If selectedFinish is not provided, skip updating step6
        // if (selectedFinish) {
        //     updateColors(selectedShape, selectedFinish);
        // }

        if (Array.isArray(corners) && corners.length > 0) {
            $('.step-indicator.badge_corners').removeClass('d-none');
            step8.html('').removeClass('not_required d-none').append(
                $('<div>', {
                    class: 'innerstep'
                }).append(
                    createRadioOptions('badge_corners', corners, 'radio-checkbox-inner radiobx'),
                    createNavButtons()
                )
            );
        } else {
            $('.step-indicator.badge_corners').addClass('d-none');
            step8.addClass('not_required d-none').html(''); // optionally clear or leave it untouched
        }


        console.log("line 278" + backings);
        step9.html('').append(
            $('<div>', {
                class: 'innerstep'
            }).append(
                createRadioOptionsWithPrice('badge_backing', backings, 'radio-checkbox-inner radiobx badge_backing_rdo'),
                $('<div>', {
                    class: 'buttons'
                }).append(
                    $('<button>', {
                        type: 'button',
                        class: 'prev green-btn',
                        html: 'Prev'
                    }),
                    $('<button>', {
                        type: 'button',
                        class: 'downloadCanvas download-btn green-btn',
                        html: 'Download'
                    })
                )
            )
        );
    }

 $(document).on("change", 'input[name="badge_shape"]', function () {
  const selectedShape = $(this).val();
  const selectedType = $('input[name="badge_type"]:checked').val();

  if(selectedType){
      const matchedItems = data.filter(
        (item) => item.badge_type === selectedType && item.badge_shapes === selectedShape
      );
      if (matchedItems.length > 0) {
        const firstSize = matchedItems[0].badge_sizes;

        // Trigger shape-related options update
        updateOptions(selectedType, selectedShape);

        // Wait for badge_size options to be rendered
        setTimeout(() => {
          $(`input[name="badge_size"]`).filter(function () {
            return $(this).val() === firstSize;
          }).prop("checked", true).trigger("change"); // Optional: trigger change if needed
        }, 2);
      }
  }else{

    updateOptions_with_out_type(selectedShape);

    const firstMatch = data.find(item => item.badge_shapes === selectedShape);
        console.log("first match" + firstMatch.badge_finishes);
        console.log("first match badge_sizes" + firstMatch.badge_sizes);

        if (firstMatch) {
            // 1️⃣ Set badge size (like you already did)
            if (firstMatch.badge_sizes) {
                const firstSize = firstMatch.badge_sizes;
                const sizeInput = $('input[name="badge_size"]').filter(function() {
                    return $(this).val() === firstSize;
                });

                if (sizeInput.length) {
                    $('input[name="badge_size"]').prop('checked', false); // clear previous
                    sizeInput.prop('checked', true); // check matching one
                }
            }

            // 2️⃣ Set badge finish (similar logic)
            if (firstMatch.badge_finishes) {
                const firstFinish = firstMatch.badge_finishes;

                //alert(firstFinish);

                // const firstFinish = firstMatch.badge_finish;
                $(`input[name="badge_finish"][value="${firstFinish}"]`).prop('checked', true).trigger('change');

            }

        }

        canvas.clear();// new line added 11-06-2025

  }

});


  // On finish change
  $("body").on("change", 'input[name="badge_finish"]', function () {
    const selectedShape = $('input[name="badge_shape"]:checked').val();
    const selectedFinish = $(this).val();
    const selectedType = $('input[name="badge_type"]:checked').val() || '';
    // alert("selectedFinish 405"+selectedFinish);
    //alert('line 591');
    updateColors(selectedShape, selectedFinish,selectedType);
    updateTextStyles();
  });

  // Update hidden SKU field when all selections are complete
  function updateSelectedSku() {
    var product_id = $("#customBadgeForm #product_id").val();
    //  console.log("Product id" +product_id);
    // Find the product in data matching all selections
    const selectedType = $('input[name="badge_type"]:checked').val() || '';
    const selectedShape = $('input[name="badge_shape"]:checked').val();
    const selectedSize = $('input[name="badge_size"]:checked').val();
    const selectedThickness = $('input[name="badge_thickness"]:checked').val();
    const selectedFinish = $('input[name="badge_finish"]:checked').val() || "";
    const selectedColor = $('input[name="badge_color"]:checked').val();
    const selectedCorner = $('input[name="badge_corners"]:checked').val() || "";
    const selectedBacking = $('input[name="badge_backing"]:checked').val();

    console.log("badge_type"+selectedType);
    console.log("badge_shape"+selectedShape);
    console.log("badge_size"+selectedSize);
    console.log("badge_thickness"+selectedThickness);
    console.log("badge_finish"+selectedFinish);
    console.log("badge_color"+selectedColor);
    console.log("badge_corners"+selectedCorner);
    console.log("badge_backing"+selectedBacking);

    // pregmatch
    const typeRegex = new RegExp(`^${selectedType}$`, "i");
    const shapeRegex = new RegExp(`^${selectedShape}$`, "i");
    const sizeRegex = new RegExp(`^${selectedSize}$`, "i");
    const thicknessRegex = new RegExp(`^${selectedThickness}$`, "i");
    const finishRegex = new RegExp(`^${selectedFinish}$`, "i");
    const backingRegex = new RegExp(`^${selectedBacking}$`, "i");
    const matchingProduct = data.find(
      (item) =>
        typeRegex.test(item.badge_type) &&
        shapeRegex.test(item.badge_shapes) &&
        sizeRegex.test(item.badge_sizes) &&
        thicknessRegex.test(item.badge_thicknesses) &&
        finishRegex.test(item.badge_finishes) &&
        item.badge_colors.includes(selectedColor) &&
        (selectedShape === "oval" ||
          item.badge_corners.includes(selectedCorner) ||
          item.badge_corners.length === 0) &&
        backingRegex.test(item.badge_backings)
    );

    //pregmatch

    if (matchingProduct) {
      selectedSkuInput.val(matchingProduct.badge_sku);
      let quantity = Math.max(1, parseInt($("#productQuantity").val()) || 0);
      const selectedBacking = $('input[name="badge_backing"]:checked');
      const backingValue = selectedBacking.val(); // e.g., "Standard Pin Back"
      const backingPrice = selectedBacking.data("price"); // e.g., 0.00
      //console.log(backingPrice);
      if (matchingProduct.badge_sku && product_id) {
        // ajax
        $.ajax({
          url: productCustomizerData.ajaxUrl,
          method: "POST",
          data: {
            action:
              quantity > 1 ? "get_price_by_quantity" : "get_min_price_by_sku", // change based on quantity
            product_id: product_id,
            sku: matchingProduct.badge_sku,
            quantity: quantity,
            backingPrice: backingPrice,
          },
          dataType: "json",
          beforeSend: function () {
            $("#total_cal_price").html("Loading..."); // show loading text
            $("#cal_price").html("Loading..."); // show loading text
          },
          success: function (response) {
            if (response.success) {
              $("#total_cal_price").html(response.data.total_price);
              $("#cal_price").html(response.data.price);
              $("#customBadgeForm #product_price").val(
                response.data.price_wo_curr
              );
            } else {
              $("#cal_price").html("Price not found");
              $("#product_price").val(0);
            }
          },
          error: function () {
            $("#cal_price").html("Error fetching price");
            $("#product_price").val(0);
          },
        });
      }
      //console.log('Selected SKU:', matchingProduct.badge_sku);
      $("#show_when_sku").removeClass("d-none");
    } else {
      $("#show_when_sku").addClass("d-none");
    }
  }

  // Update SKU whenever any option changes
  $(document).on(
    "change",
    'input[name="badge_size"], input[name="badge_thickness"], input[name="badge_finish"], input[name="badge_color"], input[name="badge_corners"], input[name="badge_backing"]',
    function () {
      // console.log('calling updateBadgePreview and updateSelectedSku fn');
      updateBadgePreview();
      updateSelectedSku();
    }
  );

  $(document).on("change", 'input[name="badge_color"]', function () {
    //console.log('color change dected  line 770');
    canvas.clear();
  });

  $("#badgeTabsContainer").append(container);

  // next
  $(document).on("click", ".next", function () {
    const formRow = $(this).closest(".formouterrow");
    let activeStep = formRow.find(".step.active");
    // Check if the active step has the title "Upload your image"
    const stepTitle =
      activeStep.find("label").length && activeStep.find("label").html()
        ? activeStep.find("label").html().trim().toLowerCase()
        : "";

    const skipValidation = stepTitle === "upload your image:";

    // If not skipping validation, check for selected radio
    if (!skipValidation && activeStep.find('input[type="radio"]').length > 0) {
      const selectedRadio = activeStep.find('input[type="radio"]:checked');
      if (selectedRadio.length === 0) {
        $.alert({
          title: "Error!",
          content: "Please choose an option before proceeding.",
          type: "red",
        });
        return; // Stop if no selection
      }
    }

    // Proceed to the next step, skipping "not_required" ones
    let nextStep = activeStep.next(".step");
    let conditional_step = 0;
    while (nextStep.length && nextStep.hasClass("not_required")) {
      //  console.log('798 checking');
      nextStep = nextStep.next(".step");
      conditional_step = 1;
    }

    if (nextStep.length) {
      activeStep.removeClass("active");
      nextStep.addClass("active");
      const indicators = formRow.find(".step-indicator");
      const nextIndex = nextStep.index() - 2; // adjust index if needed
      let prevIndex = nextIndex - 1;
      //  console.log(prevIndex)
      indicators.removeClass("active").eq(nextIndex).addClass("active");
      if (conditional_step) {
        indicators.eq(prevIndex - 1).addClass("completed");
      } else {
        indicators.eq(prevIndex).addClass("completed");
      }
      updateSelectedColumn();
    }
  });
  // Previous buttons
  $(document).on("click", ".prev", function () {
    const formRow = $(this).closest(".formouterrow");
    let activeStep = formRow.find(".step.active");
    let prevStep = activeStep.prev(".step");

    // Skip over any previous steps with the 'not_required' class
    while (prevStep.length && prevStep.hasClass("not_required")) {
      prevStep = prevStep.prev(".step");
    }

    if (prevStep.length) {
      activeStep.removeClass("active");
      prevStep.addClass("active");

      const indicators = formRow.find(".step-indicator");
      const prevIndex = prevStep.index() - 2; // adjust index if needed
      indicators
        .removeClass("active")
        .eq(prevIndex)
        .addClass("active")
        .removeClass("completed");
      updateSelectedColumn();
    }
  });

  let assetUrl_2 = productCustomizerData.pluginUrl + "images";

  function updateSelectedColumn_old(
    assetUrl = productCustomizerData.pluginUrl + "images"
  ) {
    //alert(assetUrl)
    const selectedData = {
      badgeShape: $('input[name="badge_shape"]:checked').val(),
      uploadedImage:
        $("#imgLoader")[0].files.length > 0
          ? $("#imgLoader")[0].files[0]
          : null,
      size: $('input[name="badge_size"]:checked').val(),
      thickness: $('input[name="badge_thickness"]:checked').val(),
      finish: $('input[name="badge_finish"]:checked').val(),
      color: $('input[name="badge_color"]:checked').val(),
      corners: $('input[name="badge_corners"]:checked').val(),
      backing: $('input[name="badge_backing"]:checked').val(),
    };

    //   console.log("line 709 selectedData" + selectedData);
    const $selectedColumn = $("#selected-column .select-inner ul");
    $selectedColumn.empty();

    // Badge Shape
    if (selectedData.badgeShape) {
      const shapeImageSrc = `${assetUrl}/${selectedData.badgeShape}.svg`;
      $selectedColumn.append(
        $("<li>").append(
          "Badge Shape: ",
          $("<img>", {
            src: shapeImageSrc,
            alt: selectedData.badgeShape,
          })
        )
      );
    }

    // Uploaded Image
    if (selectedData.uploadedImage) {
      const imageURL = URL.createObjectURL(selectedData.uploadedImage);
      $("#org_image").val(imageURL);
      $selectedColumn.append(
        $("<li>").append(
          "Uploaded Image: ",
          $("<img>", {
            src: imageURL,
            alt: "Uploaded Image",
            style: "max-width: 100px; display: block; margin-top: 5px;", // optional styling
          })
        )
      );
    }

    // Size
    if (selectedData.size) {
      $selectedColumn.append(
        $("<li>").append(
          "Size: ",
          $("<span>", {
            text: selectedData.size,
          })
        )
      );
    }

    // Add other fields similarly...
    if (selectedData.thickness) {
      $selectedColumn.append(
        $("<li>").append(
          "Thickness: ",
          $("<span>", {
            text: selectedData.thickness,
          })
        )
      );
    }

    if (selectedData.finish) {
      $selectedColumn.append(
        $("<li>").append(
          "Finish: ",
          $("<span>", {
            text: selectedData.finish,
          })
        )
      );
    }

    if (selectedData.color) {
      $selectedColumn.append(
        $("<li>").append(
          "Color: ",
          $("<span>", {
            text: selectedData.color,
          })
        )
      );
    }

    if (selectedData.corners) {
      $selectedColumn.append(
        $("<li>").append(
          "Corners: ",
          $("<span>", {
            text: selectedData.corners,
          })
        )
      );
    }

    if (selectedData.backing) {
      $selectedColumn.append(
        $("<li>").append(
          "Backing: ",
          $("<span>", {
            text: selectedData.backing,
          })
        )
      );
    }
  }

  function updateSelectedColumn_old(
    assetUrl = productCustomizerData.pluginUrl + "images"
  ) 
  {
    const currentStep =
      typeof getCurrentStep === "function"
        ? getCurrentStep()
        : window.currentStep || 1;
    //  alert(currentStep);
    const selectedData = {
      badgeShape: $('input[name="badge_shape"]:checked').val(),
      uploadedImage:
        $("#imgLoader")[0].files.length > 0
          ? $("#imgLoader")[0].files[0]
          : null,
      size: $('input[name="badge_size"]:checked').val(),
      thickness: $('input[name="badge_thickness"]:checked').val(),
      finish: $('input[name="badge_finish"]:checked').val(),
      color: $('input[name="badge_color"]:checked').val(),
      corners: $('input[name="badge_corners"]:checked').val(),
      backing: $('input[name="badge_backing"]:checked').val(),
      textInput: $("#textInput").val(),
      textSize: $("#textSize").val(),
      textSizeChange: $("#textSizeChange").val(),
      textColor: $("#textColor").val(),
      textColorChange: $("#textColorChange").val(),
      textFont: $("#textFont").val(),
    };
    const $selectedColumn = $("#selected-column .select-inner ul");
    $selectedColumn.empty();
    // Badge Shape
    if (selectedData.badgeShape) {
      const shapeImageSrc = `${assetUrl}/${selectedData.badgeShape}.svg`;
      $selectedColumn.append(
        $("<li>").append(
          "Badge Shape: ",
          $("<img>", {
            src: shapeImageSrc,
            alt: selectedData.badgeShape,
          })
        )
      );
    }

    // Uploaded Image
    if (selectedData.uploadedImage) {
      const imageURL = URL.createObjectURL(selectedData.uploadedImage);
      $("#org_image").val(imageURL);
      $selectedColumn.append(
        $("<li>").append(
          "Uploaded Image: ",
          $("<img>", {
            src: imageURL,
            alt: "Uploaded Image",
            style: "max-width: 100px; display: block; margin-top: 5px;",
          })
        )
      );
    }

    // Size (only on step 3)
    if (currentStep >= 2 && selectedData.size) {
      $selectedColumn.append(
        $("<li>").append("Size: ", $("<span>").text(selectedData.size))
      );
    }

    // Text Input
    // Size (only on step 3)
    if (currentStep > 3 && selectedData.textInput) {
      $selectedColumn.append(
        $("<li>").append("Text: ", $("<span>").text(selectedData.textInput))
      );
    }

    // Text Size (only if chosen)
    if (
      currentStep > 3 &&
      selectedData.textSizeChange == 1 &&
      selectedData.textSize
    ) {
      $selectedColumn.append(
        $("<li>").append(
          "Text Size: ",
          $("<span>").text(selectedData.textSize + "px")
        )
      );
    }

    // Text Color (only if chosen)
    if (
      currentStep > 3 &&
      selectedData.textColorChange == 1 &&
      selectedData.textColor
    ) {
      $selectedColumn.append(
        $("<li>").append(
          "Text Color: ",
          $("<span>")
            .css("color", selectedData.textColor)
            .text(selectedData.textColor)
        )
      );
    }

    // Text Font
    if (currentStep > 3 && selectedData.textFont) {
      $selectedColumn.append(
        $("<li>").append(
          "Text Font: ",
          $("<span>")
            .css("font-family", selectedData.textFont)
            .text(selectedData.textFont)
        )
      );
    }

    // Thickness
    if (currentStep >= 5 && selectedData.thickness) {
      $selectedColumn.append(
        $("<li>").append(
          "Thickness: ",
          $("<span>").text(selectedData.thickness)
        )
      );
    }

    // Finish (only on step 7)
    if (currentStep >= 6 && selectedData.finish) {
      $selectedColumn.append(
        $("<li>").append("Finish: ", $("<span>").text(selectedData.finish))
      );
    }

    // Color
    if (currentStep >= 7 && selectedData.color) {
      $selectedColumn.append(
        $("<li>").append("Color: ", $("<span>").text(selectedData.color))
      );
    }

    // Corners
    if (currentStep >= 6 && selectedData.corners) {
      $selectedColumn.append(
        $("<li>").append("Corners: ", $("<span>").text(selectedData.corners))
      );
    }

    // Backing
    if (currentStep >= 8 && selectedData.backing) {
      $selectedColumn.append(
        $("<li>").append("Backing: ", $("<span>").text(selectedData.backing))
      );
    }
  }

  function updateSelectedColumn(
  assetUrl = productCustomizerData.pluginUrl + "images"
) {
  const currentStep =
    typeof getCurrentStep === "function"
      ? getCurrentStep()
      : window.currentStep || 1;

  const selectedData = {
    badgeType: $('input[name="badge_type"]:checked').val(),
    badgeShape: $('input[name="badge_shape"]:checked').val(),
    uploadedImage:
      $("#imgLoader")[0].files.length > 0
        ? $("#imgLoader")[0].files[0]
        : null,
    size: $('input[name="badge_size"]:checked').val(),
    thickness: $('input[name="badge_thickness"]:checked').val(),
    finish: $('input[name="badge_finish"]:checked').val(),
    color: $('input[name="badge_color"]:checked').val(),
    corners: $('input[name="badge_corners"]:checked').val(),
    backing: $('input[name="badge_backing"]:checked').val(),
    textInput: $("#textInput").val(),
    textSize: $("#textSize").val(),
    textSizeChange: $("#textSizeChange").val(),
    textColor: $("#textColor").val(),
    textColorChange: $("#textColorChange").val(),
    textFont: $("#textFont").val(),
  };

  const $selectedColumn = $("#selected-column .select-inner ul");
  $selectedColumn.empty();

  // Badge Type
  if (selectedData.badgeType) {
    $selectedColumn.append(
      $("<li>").append("Badge Type: ", $("<span>").text(selectedData.badgeType))
    );
  }

  // Badge Shape
  if (selectedData.badgeShape && currentStep >= 1) {
    const shapeImageSrc = `${assetUrl}/${selectedData.badgeShape}.svg`;
    $selectedColumn.append(
      $("<li>").append(
        "Badge Shape: ",
        $("<img>", {
          src: shapeImageSrc,
          alt: selectedData.badgeShape,
        })
      )
    );
  }



  // Size
  if (currentStep >= 2 && selectedData.size) {
    $selectedColumn.append(
      $("<li>").append("Size: ", $("<span>").text(selectedData.size))
    );
  }

    // Uploaded Image
  if (selectedData.uploadedImage) {
    const imageURL = URL.createObjectURL(selectedData.uploadedImage);
    $("#org_image").val(imageURL);
    $selectedColumn.append(
      $("<li>").append(
        "Uploaded Image: ",
        $("<img>", {
          src: imageURL,
          alt: "Uploaded Image",
          style: "max-width: 100px; display: block; margin-top: 5px;",
        })
      )
    );
  }

  // Text Input
  if (currentStep > 3 && selectedData.textInput) {
    $selectedColumn.append(
      $("<li>").append("Text: ", $("<span>").text(selectedData.textInput))
    );
  }

  // Text Size
  if (
    currentStep > 3 &&
    selectedData.textSizeChange == 1 &&
    selectedData.textSize
  ) {
    $selectedColumn.append(
      $("<li>").append(
        "Text Size: ",
        $("<span>").text(selectedData.textSize + "px")
      )
    );
  }

  // Text Color
  if (
    currentStep > 3 &&
    selectedData.textColorChange == 1 &&
    selectedData.textColor
  ) {
    $selectedColumn.append(
      $("<li>").append(
        "Text Color: ",
        $("<span>")
          .css("color", selectedData.textColor)
          .text(selectedData.textColor)
      )
    );
  }

  // Text Font
  if (currentStep > 3 && selectedData.textFont) {
    $selectedColumn.append(
      $("<li>").append(
        "Text Font: ",
        $("<span>")
          .css("font-family", selectedData.textFont)
          .text(selectedData.textFont)
      )
    );
  }

  // Thickness
  if (currentStep >= 5 && selectedData.thickness) {
    $selectedColumn.append(
      $("<li>").append("Thickness: ", $("<span>").text(selectedData.thickness))
    );
  }

  // Finish
  if (currentStep >= 6 && selectedData.finish) {
    $selectedColumn.append(
      $("<li>").append("Finish: ", $("<span>").text(selectedData.finish))
    );
  }

  // Color
  if (currentStep >= 7 && selectedData.color) {
    $selectedColumn.append(
      $("<li>").append("Color: ", $("<span>").text(selectedData.color))
    );
  }

  // Corners
  if (currentStep >= 6 && selectedData.corners) {
    $selectedColumn.append(
      $("<li>").append("Corners: ", $("<span>").text(selectedData.corners))
    );
  }

  // Backing
  if (currentStep >= 8 && selectedData.backing) {
    $selectedColumn.append(
      $("<li>").append("Backing: ", $("<span>").text(selectedData.backing))
    );
  }
}


  function getCurrentStep() {
    const $activeStep = $("#badgeTabsContainer .formouterrow .step.active");
    const index = $activeStep.index(".step");
    //alert('index'+index);
    index == 0 ? 1 : index + 2;
    // alert('line 1107'+index);
    // console.log("current index"+index);
    return index;
  }

  function parseInches(str) {
    str = str.trim();
    if (str.includes(" ")) {
      const [whole, fraction] = str.split(" ");
      const [numerator, denominator] = fraction.split("/");
      return (
        parseFloat(whole) + parseFloat(numerator) / parseFloat(denominator)
      );
    } else if (str.includes("/")) {
      const [numerator, denominator] = str.split("/");
      return parseFloat(numerator) / parseFloat(denominator);
    } else {
      return parseFloat(str);
    }
  }
  function setDefaultShapeAndSize() {
    // Parse the JSON
    const data = JSON.parse($("#badgeData").html());
    // Get the first badge object from the array
    const firstBadge = data[0];
    if (!firstBadge) return; // No data to process
    // console.log("badge_shapes: " + firstBadge.badge_shapes);
    // Set the default shape
    if (firstBadge.badge_shapes) {
      //  $('#badgeShapes').val(firstBadge.badge_shapes).trigger('change');
      $('input[name="badge_shape"]')
        .filter('[value="' + firstBadge.badge_shapes + '"]')
        .prop("checked", true)
        .trigger("change");
    }

    //  console.log("badge_sizes: " + firstBadge.badge_sizes);

    // Set the default size
    if (firstBadge.badge_sizes) {
      $("#badge_size1").prop("checked", true).trigger("change");
      // //$('input[name="badge_size"]').filter('[value="' + firstBadge.badge_sizes + '"]').prop('checked', true).trigger('change');
    }
  }
  $(document).on("click", ".downloadCanvas", function () {
    const dataURL = canvas.toDataURL({
      format: "png",
      quality: 1,
    });
    const link = document.createElement("a");
    link.href = dataURL;
    link.download = "badge.png";
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
  });
  jQuery("#multiStepForm").on("submit", function (e) {
    e.preventDefault();
    // alert('hi 955');
    jQuery(this).find('button[type="submit"]').text("Processing...");

    // Optional: disable the button to prevent multiple submissions
    jQuery(this).find('button[type="submit"]').prop("disabled", true);
    const form = this;
    const formData = new FormData(this);
    // Add canvas data
    const canvasData = canvas.toDataURL("image/png"); // assuming `canvas` is your Fabric.js canvas
    formData.append("canvas_data", canvasData);
    formData.append("action", "custom_badge_add_to_cart");
    const fileInput = form.querySelector("#imgLoader");
    if (fileInput && fileInput.files.length > 0) {
      //   console.log("file input"+fileInput.files[0])
      formData.append("original_image_new", fileInput.files[0]);
    }
    // console.log(formData);
    jQuery.ajax({
      url: wc_add_to_cart_params.ajax_url,
      type: "POST",
      // method: 'POST',
      data: formData,
      contentType: false,
      processData: false,
      success: function (response) {
        if (response.success) {
          // Use jsConfirm
          $.confirm({
            title: "Thank you!",
            content: "Product successfully added to your cart",
            type: "green",
            buttons: {
              ok: {
                text: "OK",
                btnClass: "btn-green",
                action: function () {
                  // Redirect to the cart page
                  window.location.href = wc_add_to_cart_params.cart_url;
                },
              },
            },
          });
        } else {
          $.alert({
            title: "Error!",
            content: "Something went wrong!",
            type: "red",
          });
        }
      },
    });
  });

  function decimalToFraction(decimal) {
    if (!Number.isFinite(decimal)) return "";
    const tolerance = 1.0e-6;
    const whole = Math.floor(decimal);
    const frac = decimal - whole;
    if (frac < tolerance) return `${whole}`; // It's basically an integer
    let numerator = 1;
    let denominator = 1;

    while (
      Math.abs(numerator / denominator - frac) > tolerance &&
      denominator <= 64
    ) {
      denominator++;
      numerator = Math.round(frac * denominator);
    }
    const simplified = simplifyFraction(numerator, denominator);
    return whole > 0
      ? `${whole} ${simplified.numerator}/${simplified.denominator}`
      : `${simplified.numerator}/${simplified.denominator}`;
  }

  function simplifyFraction(numerator, denominator) {
    const gcd = (a, b) => (b ? gcd(b, a % b) : a);
    const divisor = gcd(numerator, denominator);
    return {
      numerator: numerator / divisor,
      denominator: denominator / divisor,
    };
  }

  function parseFractionalDimension(part) {
    part = part.replace(/["']/g, "").trim(); // remove quotes
    // Handle mixed fractions like "1 1/2"
    if (part.includes(" ")) {
      const [whole, fraction] = part.split(" ");
      const [numerator, denominator] = fraction.split("/");
      return (
        parseInt(whole, 10) +
        parseInt(numerator, 10) / parseInt(denominator, 10)
      );
    }
    // Handle pure fractions like "1/2"
    if (part.includes("/")) {
      const [numerator, denominator] = part.split("/");
      return parseInt(numerator, 10) / parseInt(denominator, 10);
    }
    // Handle decimal or integer
    return parseFloat(part);
  }

  function updateBadgePreview() {
    // not required
    console.log("calling line 1254");
    const shape = $('input[name="badge_shape"]:checked').val();
    const color = $('input[name="badge_color"]:checked').val() || "#fff";
    const corner = $('input[name="badge_corners"]:checked').val();
    const size = $('input[name="badge_size"]:checked').val();
    const finish = jQuery('input[name="badge_finish"]:checked').val();

    const textInput = $("#textInput").val();
    const textFont = $("#textFont").val();
    const textSize = $("#textSize").val();
    const textColor = $("#textColor").val();
    // Parse size
    let widthIn = 1,
      heightIn = 1;
    if (size) {
      const [first, second] = size.split("x").map(parseFractionalDimension);
      widthIn = Math.max(first, second);
      heightIn = Math.min(first, second);
    }

    const ppi = 150;
    const canvasWidth = widthIn * ppi;
    const canvasHeight = heightIn * ppi;

    // Apply canvas DOM + style
    const canvasEl = document.getElementById("badgeCanvas");
    canvasEl.width = canvasWidth;
    canvasEl.height = canvasHeight;
    $(".canvasSec").css({
      width: canvasWidth + "px",
      height: canvasHeight + "px",
    });
    $("#canvasWidth").text(decimalToFraction(widthIn) + '"');
    $("#canvasHeight").text(decimalToFraction(heightIn) + '"');

    // Preserve previous user image and text
    const prevImage = userImage;
    const prevText = currentTextObj;

    canvas.clear();
    canvas.setWidth(canvasWidth);
    canvas.setHeight(canvasHeight);

    if (typeof badgeShapeImages !== "undefined") {

    // ----- Background image if exists -----
          let bgImageURL = "";
          if (shape === "Rectangle" && badgeShapeImages.rectangle) {
            bgImageURL = badgeShapeImages.rectangle;
          } else if (shape === "Oval" && badgeShapeImages.oval) {
            bgImageURL = badgeShapeImages.oval;
          }

          if (shape && finish && color) {
            const key = `badge_image_${shape.toLowerCase()}_${finish.toLowerCase()}_${color.replace(
              "#",
              ""
            )}`;
            const imageUrl = badgeImageMap[key];
            if (imageUrl) {
              bgImageURL = imageUrl;
            }
          }
    }

    // alert("bgImageURL"+bgImageURL);

   if (typeof bgImageURL !== "undefined" && (bgImageURL)) {
      fabric.Image.fromURL(bgImageURL, function (img) {
        // Force stretch to canvas size
        img.set({
          scaleX: canvasWidth / img.width,
          scaleY: canvasHeight / img.height,
          left: 0,
          top: 0,
          originX: "left",
          originY: "top",
          selectable: false,
          evented: false,
        });

        canvas.setBackgroundImage(img, canvas.renderAll.bind(canvas));
      });
    } else {
      // Fallback to shape background
      let bgShape;
      if (shape === "Rectangle") {
        bgShape = new fabric.Rect({
          left: 0,
          top: 0,
          width: canvasWidth,
          height: canvasHeight,
          fill: color,
          rx: corner === "Rounded" ? 20 : 0,
          ry: corner === "Rounded" ? 20 : 0,
          selectable: false,
        });
      } else {
        bgShape = new fabric.Ellipse({
          left: canvasWidth / 2,
          top: canvasHeight / 2,
          rx: canvasWidth / 2,
          ry: canvasHeight / 2,
          originX: "center",
          originY: "center",
          fill: color,
          selectable: false,
        });
      }

      canvas.setBackgroundImage(null);
      canvas.add(bgShape);
      canvas.sendToBack(bgShape);
    }

    // Set hidden fields
    $("#badge_shape_input").val(shape);
    $("#badge_size_input").val(size);
    $("#badge_thickness_input").val(
      $('input[name="badge_thickness"]:checked').val()
    );
    $("#badge_finish_input").val($('input[name="badge_finish"]:checked').val());
    $("#badge_color_input").val(color);
    $("#badge_corner_input").val(corner);
    $("#badge_backing_input").val(
      $('input[name="badge_backing"]:checked').val()
    );

    // text fields
    $("#badge_custom_text").val(textInput);
    $("#badge_custom_text_size").val(textSize);
    $("#badge_custom_text_color").val(textColor);
    $("#badge_custom_text_font").val(textFont);

    // Re-add user image with clipPath
    if (prevImage) {
      const clipPath =
        shape === "Rectangle"
          ? new fabric.Rect({
              width: canvasWidth,
              height: canvasHeight,
              left: 0,
              top: 0,
              absolutePositioned: true,
            })
          : new fabric.Ellipse({
              rx: canvasWidth / 2,
              ry: canvasHeight / 2,
              left: canvasWidth / 2,
              top: canvasHeight / 2,
              originX: "center",
              originY: "center",
              absolutePositioned: true,
            });

      prevImage.clipPath = clipPath;
      prevImage.objectCaching = false;
      canvas.add(prevImage);
      canvas.bringToFront(prevImage);
    }

    // Add or update text
    if (textInput.trim() !== "") {
      if (!prevText) {
        currentTextObj = new fabric.Textbox(textInput, {
          left: 100,
          top: 100,
          fontSize: parseInt($("#textSize").val()) || 20,
          fill: $("#textColor").val() || "#000",
          fontFamily: $("#textFont").val() || "Arial",
        });
      } else {
        currentTextObj = prevText;
        currentTextObj.set({
          text: textInput,
          fontSize: parseInt($("#textSize").val()),
          fill: $("#textColor").val(),
          fontFamily: $("#textFont").val(),
        });
      }
      currentTextObj.controls.mtr = customRotateControl;
      canvas.add(currentTextObj);
      canvas.bringToFront(currentTextObj);
    }

    canvas.controlsAboveOverlay = true;
    canvas.preserveObjectStacking = true;
    canvas.requestRenderAll();
  }

  function updateBadgePreview_latest() {
    const shape = $('input[name="badge_shape"]:checked').val();
    const color = $('input[name="badge_color"]:checked').val() || "#fff";
    const corner = $('input[name="badge_corners"]:checked').val();
    const size = $('input[name="badge_size"]:checked').val();
    // Parse size
    let first = 1,
      second = 1;
    if (size) {
      const sizeParts = size.split("x").map(parseFractionalDimension);
      //const sizeParts = size.split('x').map(part => parseFloat(part.replace(/["']/g, '').trim()));
      //console.log("sizeParts"+sizeParts);
      if (sizeParts.length === 2) {
        first = sizeParts[0];
        second = sizeParts[1];
      }
    }

    // Ensure width ≥ height
    let widthIn = Math.max(first, second);
    let heightIn = Math.min(first, second);
    const pixelPerInch = 150;
    const canvasWidthPx = widthIn * pixelPerInch;
    const canvasHeightPx = heightIn * pixelPerInch;
    // Update canvas DOM element
    const canvasEl = document.getElementById("badgeCanvas");
    canvasEl.width = canvasWidthPx;
    canvasEl.height = canvasHeightPx;
    $(".canvasSec").css({
      width: canvasWidthPx + "px",
      height: canvasHeightPx + "px",
    });
    $("#canvasWidth").text(decimalToFraction(widthIn) + '"');
    $("#canvasHeight").text(decimalToFraction(heightIn) + '"');
    // Reset canvas
    canvas.setWidth(canvasWidthPx);
    canvas.setHeight(canvasHeightPx);
    //console.log('line comment 1146');
    //  console.log('selected color'+color);
    // canvas.clear();
    if (!shape) return;
    // Draw background shape
    let shapeObj;
    if (shape === "Rectangle") {
      shapeObj = new fabric.Rect({
        left: 0,
        top: 0,
        width: canvasWidthPx,
        height: canvasHeightPx,
        fill: color,
        rx: corner === "Rounded" ? 20 : 0,
        ry: corner === "Rounded" ? 20 : 0,
        selectable: false,
      });
    } else {
      shapeObj = new fabric.Ellipse({
        left: canvasWidthPx / 2,
        top: canvasHeightPx / 2,
        originX: "center",
        originY: "center",
        rx: canvasWidthPx / 2,
        ry: canvasHeightPx / 2,
        fill: color,
        selectable: false,
      });
    }

    canvas.add(shapeObj);
    canvas.sendToBack(shapeObj);
    // Set hidden inputs
    $("#badge_shape_input").val(shape);
    $("#badge_size_input").val(size);
    $("#badge_thickness_input").val(
      $('input[name="badge_thickness"]:checked').val()
    );
    $("#badge_finish_input").val($('input[name="badge_finish"]:checked').val());
    $("#badge_color_input").val(color);
    $("#badge_corner_input").val(corner);
    $("#badge_backing_input").val(
      $('input[name="badge_backing"]:checked').val()
    );
    // Add and clip image
    if (userImage) {
      // Create updated clipPath
      let clipPath;
      if (shape === "Rectangle") {
        clipPath = new fabric.Rect({
          width: canvasWidthPx,
          height: canvasHeightPx,
          left: 0,
          top: 0,
          absolutePositioned: true,
        });
      } else {
        clipPath = new fabric.Ellipse({
          rx: canvasWidthPx / 2,
          ry: canvasHeightPx / 2,
          left: canvasWidthPx / 2,
          top: canvasHeightPx / 2,
          originX: "center",
          originY: "center",
          absolutePositioned: true,
        });
      }
      userImage.clipPath = clipPath;
      canvas.add(userImage);
      canvas.bringToFront(userImage);
    }

    canvas.renderAll();
  }

  function getClipPath() {
    const shape = $('input[name="badge_shape"]:checked').val();
    if (shape === "rectangle") {
      return new fabric.Rect({
        width: badgeWidth,
        height: badgeHeight,
        left: 0,
        top: 0,
        absolutePositioned: true,
      });
    } else {
      return new fabric.Ellipse({
        rx: badgeWidth / 2,
        ry: badgeHeight / 2,
        left: badgeWidth / 2,
        top: badgeHeight / 2,
        originX: "center",
        originY: "center",
        absolutePositioned: true,
      });
    }
  }
  //  let userImage;
  $("#imgLoader").on("change", function (e) {
    const file = e.target.files[0];
    //console.log(file)
    if (!file) return;
    const reader = new FileReader();
    reader.onload = function (f) {
      fabric.Image.fromURL(f.target.result, function (img) {
        // console.log("image"+img);
        // Resize the image before adding
        const maxWidth = canvas.getWidth();
        const maxHeight = canvas.getHeight();
        // Scale down proportionally if needed
        const scaleX = maxWidth / img.width;
        const scaleY = maxHeight / img.height;
        const scale = Math.min(scaleX, scaleY, 1); // Don’t upscale
        img.scale(scale);
        img.set({
          left: (canvas.getWidth() - img.getScaledWidth()) / 2,
          top: (canvas.getHeight() - img.getScaledHeight()) / 2,
          hasControls: true,
          hasBorders: true,
        });

        // Save reference and add to canvas
        userImage = img;
        canvas.add(userImage);
        canvas.bringToFront(userImage);

        // Apply clipPath again if needed
        updateBadgePreview();
      });
    };
    reader.readAsDataURL(file);
    updateSelectedColumn();
  });

  // Helper: add mask overlay shape to simulate visual boundary
  function addMaskOverlay() {
    const shape = $('input[name="badge_shape"]:checked').val();
    const canvasWidth = canvas.getWidth();
    const canvasHeight = canvas.getHeight();

    // Remove previous mask if any
    canvas.getObjects("overlayShape").forEach((obj) => canvas.remove(obj));

    const maskShape =
      shape === "Rectangle"
        ? new fabric.Rect({
            left: 0,
            top: 0,
            width: canvasWidth,
            height: canvasHeight,
            fill: "rgba(255,255,255,0.01)", // transparent click-through mask
            selectable: false,
            evented: false,
          })
        : new fabric.Ellipse({
            left: canvasWidth / 2,
            top: canvasHeight / 2,
            originX: "center",
            originY: "center",
            rx: canvasWidth / 2,
            ry: canvasHeight / 2,
            fill: "rgba(255,255,255,0.01)",
            selectable: false,
            evented: false,
          });

    // Tag it for removal later
    maskShape.set("type", "overlayShape");
    canvas.add(maskShape);
    canvas.sendToBack(maskShape);
  }

  canvas.on("selection:created", updateControls);
  canvas.on("selection:updated", updateControls);
  canvas.on("selection:cleared", function () {
    $("#canvasControls").hide();
    $(".zoom-controls").addClass("d-none");
  });

  function updateControls(e) {
    const obj = e.selected ? e.selected[0] : e.target;
    if (obj === userImage) {
      const canvasOffset = $(canvas.upperCanvasEl).offset();
      const bounds = obj.getBoundingRect();
      $(".zoom-controls").removeClass("d-none");

      // Position controls near the selected image
      $("#canvasControls")
        .css({
          top: canvasOffset.top + bounds.top - 40,
          left: canvasOffset.left + bounds.left + bounds.width - 80,
        })
        .show();
    } else {
      $("#canvasControls").hide();
      $(".zoom-controls").addClass("d-none");
    }
  }

 

  const minScale = 0.1;
  const maxScale = 3; // max zoom in allowed

  $("#resizeRange").attr({
    min: minScale,
    max: maxScale,
    step: 0.01,
    value: userImage ? userImage.scaleX : 1,
  });

  $("#resizeRange").on("input", function () {
    if (!userImage) return;

    const scale = parseFloat(this.value);

    userImage.scaleX = scale;
    userImage.scaleY = scale;
    userImage.setCoords(); // important: update controls bounding box
    canvas.requestRenderAll();

    $("#resizeValue").text(scale.toFixed(2)); // display current scale value
  });

  canvas.on("object:scaling", function (e) {
    if (e.target === userImage) {
      $("#resizeRange").val(e.target.scaleX.toFixed(2));
      $("#resizeValue").text(e.target.scaleX.toFixed(2));
    }
  });

  const fileInput = document.getElementById("imgLoader");
  const selectFileBtn = document.getElementById("selectFileBtn");
  const fileNameDisplay = document.getElementById("fileNameDisplay");

  // --- Utility Function ---
  function updateFileName(file) {
    if (file) {
      fileNameDisplay.textContent = file.name;
    } else {
      fileNameDisplay.textContent = "No file selected";
    }
  }

  // --- Event Listeners ---

  // Trigger hidden file input when "Choose File" button is clicked
  selectFileBtn.addEventListener("click", () => {
    fileInput.click();
  });

  // Handle file selection
  fileInput.addEventListener("change", (event) => {
    const selectedFile = event.target.files[0]; // Get the first selected file
    updateFileName(selectedFile);
  });

  // Initialize display on load
  updateFileName(null);
  $("#deleteImageBtn").on("click", function (e) {
    e.preventDefault();
    if (userImage) {
      canvas.remove(userImage);
      userImage = null;
      $("#canvasControls").hide();
      canvas.discardActiveObject().renderAll();
      $("#imgLoader").val(""); // resets file input
    }
    updateSelectedColumn();
    updateFileName(null);
  });

  // Render the icon in the control
  function renderIcon(icon) {
    return function (ctx, left, top, styleOverride, fabricObject) {
      const size = this.cornerSize;
      ctx.save();
      ctx.translate(left, top);
      ctx.drawImage(icon, -size / 2, -size / 2, size, size);
      ctx.restore();
    };
  }

  // What happens when the icon is clicked
  function deleteObject(eventData, transform) {
    const target = transform.target;
    const canvas = target.canvas;
    canvas.remove(target);
    canvas.requestRenderAll();
  }

  // When the user changes any option, update preview
  $(document).on("change", 'input[type="radio"]', function () {
    updateBadgePreview();
    $("#selected-column").show();
    updateSelectedColumn();
  });

  $(document).on(
    "change",
    "#textInput,#textSize,#textColor,#textFont",
    function () {
      updateBadgePreview();
      $("#selected-column").show();
      updateSelectedColumn();
    }
  );

  setDefaultShapeAndSize();

  // Initialize preview
  updateBadgePreview();
  updateSelectedColumn();

  function updatePrice() {
    var product_id = $("#customBadgeForm #product_id").val();
    let quantity = parseInt($("#productQuantity").val());
    let sku = $("#badge_sku").val();
    const selectedBacking = $('input[name="badge_backing"]:checked');
    const backingValue = selectedBacking.val(); // e.g., "Standard Pin Back"
    const backingPrice = selectedBacking.data("price"); // e.g., 0.00
    //   console.log(backingPrice);

    $.ajax({
      url: productCustomizerData.ajaxUrl,
      method: "POST",
      data: {
        action: "get_price_by_quantity",
        product_id: product_id,
        sku: sku,
        quantity: quantity,
        backingPrice: backingPrice,
      },
      dataType: "json",
      beforeSend: function () {
        $("#total_cal_price").html("Loading..."); // show loading text
        $("#cal_price").html("Loading..."); // show loading text
      },
      success: function (response) {
        if (response.success) {
          $("#cal_price").html(response.data.price);
          $("#total_cal_price").html(response.data.total_price);
          $("#customBadgeForm #product_price").val(response.data.price_wo_curr);
          $("#customBadgeForm #badge_qty").val(quantity);
        } else {
          $("#cal_price").html("Price not found");
          $("#customBadgeForm #product_price").val(0);
          $("#customBadgeForm #badge_qty").val(quantity);
        }
      },
      error: function () {
        $("#cal_price").text("Error fetching price");
        $("#customBadgeForm #product_price").val(0);
      },
    });
  }

  canvas.on("object:scaling", function (e) {
    //  console.log('line 420');
    // if (e.target === userImage) {
    //   // Call the function to fit the image inside the oval
    //   resizeUserImageToFitOvalCanvas();
    // }
  });

  // Increase quantity
  $(".plus-btn").click(function () {
    let $input = $("#productQuantity");
    let currentVal = parseInt($input.val());
    let max = parseInt($input.attr("max"));
    if (!isNaN(currentVal) && currentVal < max) {
      $input.val(currentVal + 1);
      updatePrice(); // Trigger AJAX after quantity changes
    }
  });

  // Decrease quantity
  $(".minus-btn").click(function () {
    let $input = $("#productQuantity");
    let currentVal = parseInt($input.val());
    let min = parseInt($input.attr("min"));
    if (!isNaN(currentVal) && currentVal > min) {
      $input.val(currentVal - 1);
      updatePrice(); // Trigger AJAX after quantity changes
    }
  });

  $("#productQuantity").on("change", function () {
    updatePrice(); // Trigger AJAX when manually typed
  });

  const textSizeInput = $("<input>", {
    type: "range",
    id: "textSize",
    min: 10,
    max: 100,
    value: 24,
  });

  $("#badgeTabsContainer #textSize").on("change", function () {
    const newSize = $(this).val();
    //alert(newSize);
    $("#textSizeDisplay").text(newSize + "px");
  });

  function updateActiveTextbox() {
    const obj = canvas.getActiveObject();
    if (!obj || obj.type !== "textbox") return;

    obj.set({
      text: $("#textInput").val(),
      fontSize: parseInt($("#textSize").val()),
      fill: $("#textColor").val(),
      fontFamily: $("#textFont").val(),
    });

    canvas.setActiveObject(obj); // Ensure stays active
    canvas.requestRenderAll();
  }

  $("#textInput").on("input", function () {
    const text = $(this).val();

    // If no current text object, create one
    if (!currentTextObj || !canvas.getObjects().includes(currentTextObj)) {
      currentTextObj = new fabric.Textbox(text, {
        left: canvas.width / 2,
        top: canvas.height / 2,
        originX: "center",
        originY: "center",
        fontSize: parseInt($("#textSize").val()),
        fill: $("#textColor").val(),
        fontFamily: $("#textFont").val(),
        editable: true,
      });

      canvas.add(currentTextObj);
    } else {
      currentTextObj.set("text", text);
    }

    canvas.setActiveObject(currentTextObj);
    canvas.requestRenderAll();
  });

  function updateTextStyles() {
    if (!currentTextObj) return;
    currentTextObj.set({
      fontSize: parseInt($("#textSize").val()),
      fill: $("#textColor").val(),
      fontFamily: $("#textFont").val(),
    });
    canvas.requestRenderAll();
  }

  $("#textSize, #textColor, #textFont").on("input change", updateTextStyles);

  $("#textColor").on("change", function () {
    $("#textColorChange").val(1);
  });

  $("#textSize").on("change", function () {
    $("#textSizeChange").val(1);
  });

  const icon = document.getElementById("custom-rotate-icon");

  // Render function
  function renderRotateIcon(ctx, left, top) {
    const size = this.cornerSize;
    if (icon && icon.complete) {
      ctx.drawImage(icon, left - size / 2, top - size / 2, size, size);
    }
  }

  // Custom rotate control
  const customRotateControl = new fabric.Control({
    x: 0,
    y: -0.5,
    offsetY: -40,
    cursorStyle: "crosshair",
    actionHandler: fabric.controlsUtils.rotationWithSnapping,
    actionName: "rotate",
    render: renderRotateIcon,
    cornerSize: 24,
  });

  // Apply globally
  function applyRotateControlGlobally() {
    fabric.Object.prototype.controls.mtr = customRotateControl;
    canvas.requestRenderAll();
  }

  // Ensure icon is loaded before applying
  if (!icon.complete) {
    icon.onload = applyRotateControlGlobally;
  } else {
    applyRotateControlGlobally();
  }

  $("#zoomInBtn").on("click", () => scaleImage(1.1));
  $("#zoomOutBtn").on("click", () => scaleImage(0.9));

  function scaleImage(factor) {
    if (userImage) {
      userImage.scaleX *= factor;
      userImage.scaleY *= factor;
      canvas.requestRenderAll();
    }
  }

  /* canvas image change*/

  jQuery(document).on(
    "change",
    'input[name="badge_color"], select[name="badge_color"]',
    function () {
      const selectedColor = jQuery(this).val(); // e.g., "#aa1919"
      // Assuming these values come from somewhere (selected badge options)
      const shape =
        jQuery('input[name="badge_shape"]:checked').val() || "rectangle";
      const finish =
        jQuery('input[name="badge_finish"]:checked').val() || "brushed";

      const key = `badge_image_${shape.toLowerCase()}_${finish.toLowerCase()}_${selectedColor.replace(
        "#",
        ""
      )}`;
      const imageUrl = badgeImageMap[key];

      if (imageUrl) {
        fabric.Image.fromURL(imageUrl, function (img) {
          canvas.setBackgroundImage(img, canvas.renderAll.bind(canvas), {
            scaleX: canvas.width / img.width,
            scaleY: canvas.height / img.height,
          });
        });
      } else {
        // Optionally clear the background
        canvas.setBackgroundImage(null, canvas.renderAll.bind(canvas));
      }
    }
  );

  /* canvas image change*/

  /* after badge_type*/

// Utility function to get unique values
function getUniqueValues(data, key) {
  const values = data.map((item) => item[key]);
  return [...new Set(values)];
}


function populateOptionsShape(name, options) {
  const wrapper = $(`[name="${name}"]`).closest(".option-wrapper");
  wrapper.empty(); // Clear previous content

  const optionsContainer = $("<div>", {
    class: "options-container",
  });

  // Append the radio options with images inside the container
  const imageOptions = createRadioOptionsWithImages(
    name,
    options,
    productCustomizerData.pluginUrl + "images"
  );

  optionsContainer.append(imageOptions);

  // Append to the wrapper
  wrapper.append(optionsContainer);
}


// Function to populate radio or select inputs (simple version)
function populateOptions(name, options) {
  const container = $(`[name="${name}"]`).closest(".option-wrapper");
  container.empty();

  options.forEach((opt) => {
    const inputId = `${name}_${opt.toString().replace(/\s+/g, "_")}`;
    const input = $("<input>", {
      type: "radio",
      name: name,
      id: inputId,
      value: opt,
    });

    const label = $("<label>", {
      for: inputId,
      text: opt,
    });

    container.append($("<div>").append(input, label));
  });
}

// Function to populate color swatches
function populateColorOptions(name, colorArray) {
  const container = $(`[name="${name}"]`).closest(".option-wrapper");
  container.empty();

  colorArray.forEach((color, index) => {
    const inputId = `${name}_${index}`;
    const input = $("<input>", {
      type: "radio",
      name: name,
      id: inputId,
      value: color,
    });

    const label = $("<label>", {
      for: inputId,
      css: {
        backgroundColor: color,
        width: "30px",
        height: "30px",
        display: "inline-block",
        borderRadius: "50%",
        border: "1px solid #ccc",
        marginRight: "5px",
      },
    });

    container.append($("<div>").append(input, label));
  });
}

// Main function: update other options based on selected badge_type
function updateOptionsOnBadgeTypeChange(selectedType) {
  const filtered = data.filter((item) => item.badge_type === selectedType);

  // Get unique values from filtered set
  const shapes = getUniqueValues(filtered, "badge_shapes");
  const sizes = getUniqueValues(filtered, "badge_sizes");
  const finishes = getUniqueValues(filtered, "badge_finishes");

  // Combine all colors from matching entries
  const colors = [...new Set(filtered.flatMap((item) => item.badge_colors))];

  // Populate respective UI elements
  populateOptionsShape("badge_shape", shapes);

}

jQuery('#badge_type1').trigger('click');

// Event listener for badge_type change
jQuery(document).on("change", 'input[name="badge_type"]', function ($) {
  const selectedType = jQuery(this).val();
  updateOptionsOnBadgeTypeChange(selectedType);
});
});

document.addEventListener("DOMContentLoaded", function () {
  const fileInput = document.getElementById("upload_file");
  const fileNameDisplay = document.getElementById("file-name"); // Targets the span with id="file-name"

  if (fileInput && fileNameDisplay) {
    // Good practice to check if elements exist
    fileInput.addEventListener("change", function () {
      if (this.files && this.files.length > 0) {
        // Update the span with the name of the first selected file
        fileNameDisplay.textContent = this.files[0].name;
      } else {
        // If no file is selected (e.g., dialog cancelled)
        fileNameDisplay.textContent = "No file chosen";
      }
    });
  }
});