<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
			
<footer>
    <div class="container">
        <div class="row">
            <div class="col-lg-4 col-md-6">

				<?php 
					$footer_logo = get_field('footer_logo', 'option'); 
					$footer_logo_alt = ($footer_logo['alt']) ? ($footer_logo['alt']) : ($footer_logo['title']);
				?>
                <a href="<?php echo get_site_url(); ?>" class="logo"><img src="<?php echo esc_url($footer_logo['url']); ?>" alt="<?php echo $footer_logo_alt; ?>"></a>

                <p><?php echo get_field('text_below_logo', 'option'); ?></p>

                <ul class="social-icon">
					<?php if(have_rows('social_links', 'option')) : ?>
					<?php while(have_rows('social_links', 'option')) : the_row(); ?>

					<?php 
						$icon = get_sub_field('icon', 'option'); 
						$icon_alt = ($icon['alt']) ? ($icon['alt']) : ($icon['title']);
					?>
                    <li><a href="<?php echo get_sub_field('link', 'option'); ?>" target="_blank"><img src="<?php echo esc_url($icon['url']); ?>" alt="<?php echo $icon_alt; ?>"></a></li>

                    <?php endwhile; endif; ?>
                </ul>

            </div>

            <div class="col-lg-2 col-md-3 mx-auto">

                <h5><?php echo get_field('quick_links', 'option'); ?></h5>

                <ul class="footer-menu">
					<?php
						wp_nav_menu(
							array(
								'menu' => 'Quick Links',
								'items_wrap'     => '%3$s',
								'container'      => false,
								
							)
						);
					?>
                </ul>
            </div>

            <div class="col-lg-2 col-md-3">

                <h5><?php echo get_field('legal_information', 'option'); ?></h5>

                <ul class="footer-menu">
					<?php
						wp_nav_menu(
							array(
								'menu' => 'Legal Information',
								'items_wrap'     => '%3$s',
								'container'      => false,
								
							)
						);
					?>
                </ul>
            </div>

            <div class="col-lg-3">

                <h5><?php echo get_field('subscribe_our_newsletter', 'option'); ?></h5>

                <div class="form-wraper">

                    <?php echo do_shortcode('[contact-form-7 id="1a8cf95" title="Footer Subscription Form"]'); ?>

                </div>
            </div>
            <div class="col-lg-12">
                <h6>© <?php echo date('Y'); ?> <?php echo get_field('copyright_text', 'option'); ?></h6>
            </div>
        </div>
    </div>
</footer>

<!-- <script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js"></script> -->
<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.slimNav_sk78.min.js"></script>   
<script src="<?php echo get_template_directory_uri(); ?>/js/owl.carousel.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/script.js"></script>


<?php wp_footer(); ?>

</body>
</html>
