<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

// This theme requires WordPress 5.3 or later.
if ( version_compare( $GLOBALS['wp_version'], '5.3', '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
}

if ( ! function_exists( 'twenty_twenty_one_setup' ) ) {
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 *
	 * @since Twenty Twenty-One 1.0
	 *
	 * @return void
	 */
	function twenty_twenty_one_setup() {

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * This theme does not use a hard-coded <title> tag in the document head,
		 * WordPress will provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/**
		 * Add post-formats support.
		 */
		add_theme_support(
			'post-formats',
			array(
				'link',
				'aside',
				'gallery',
				'image',
				'quote',
				'status',
				'video',
				'audio',
				'chat',
			)
		);

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 1568, 9999 );

		register_nav_menus(
			array(
				'primary' => esc_html__( 'Primary menu', 'twentytwentyone' ),
				'footer'  => esc_html__( 'Secondary menu', 'twentytwentyone' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
				'navigation-widgets',
			)
		);

		/*
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		$logo_width  = 300;
		$logo_height = 100;

		add_theme_support(
			'custom-logo',
			array(
				'height'               => $logo_height,
				'width'                => $logo_width,
				'flex-width'           => true,
				'flex-height'          => true,
				'unlink-homepage-logo' => true,
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );
		$background_color = get_theme_mod( 'background_color', 'D1E4DD' );
		if ( 127 > Twenty_Twenty_One_Custom_Colors::get_relative_luminance_from_hex( $background_color ) ) {
			add_theme_support( 'dark-editor-style' );
		}

		$editor_stylesheet_path = './assets/css/style-editor.css';

		// Note, the is_IE global variable is defined by WordPress and is used
		// to detect if the current browser is internet explorer.
		global $is_IE;
		if ( $is_IE ) {
			$editor_stylesheet_path = './assets/css/ie-editor.css';
		}

		// Enqueue editor styles.
		add_editor_style( $editor_stylesheet_path );

		// Add custom editor font sizes.
		add_theme_support(
			'editor-font-sizes',
			array(
				array(
					'name'      => esc_html__( 'Extra small', 'twentytwentyone' ),
					'shortName' => esc_html_x( 'XS', 'Font size', 'twentytwentyone' ),
					'size'      => 16,
					'slug'      => 'extra-small',
				),
				array(
					'name'      => esc_html__( 'Small', 'twentytwentyone' ),
					'shortName' => esc_html_x( 'S', 'Font size', 'twentytwentyone' ),
					'size'      => 18,
					'slug'      => 'small',
				),
				array(
					'name'      => esc_html__( 'Normal', 'twentytwentyone' ),
					'shortName' => esc_html_x( 'M', 'Font size', 'twentytwentyone' ),
					'size'      => 20,
					'slug'      => 'normal',
				),
				array(
					'name'      => esc_html__( 'Large', 'twentytwentyone' ),
					'shortName' => esc_html_x( 'L', 'Font size', 'twentytwentyone' ),
					'size'      => 24,
					'slug'      => 'large',
				),
				array(
					'name'      => esc_html__( 'Extra large', 'twentytwentyone' ),
					'shortName' => esc_html_x( 'XL', 'Font size', 'twentytwentyone' ),
					'size'      => 40,
					'slug'      => 'extra-large',
				),
				array(
					'name'      => esc_html__( 'Huge', 'twentytwentyone' ),
					'shortName' => esc_html_x( 'XXL', 'Font size', 'twentytwentyone' ),
					'size'      => 96,
					'slug'      => 'huge',
				),
				array(
					'name'      => esc_html__( 'Gigantic', 'twentytwentyone' ),
					'shortName' => esc_html_x( 'XXXL', 'Font size', 'twentytwentyone' ),
					'size'      => 144,
					'slug'      => 'gigantic',
				),
			)
		);

		// Custom background color.
		add_theme_support(
			'custom-background',
			array(
				'default-color' => 'd1e4dd',
			)
		);

		// Editor color palette.
		$black     = '#000000';
		$dark_gray = '#28303D';
		$gray      = '#39414D';
		$green     = '#D1E4DD';
		$blue      = '#D1DFE4';
		$purple    = '#D1D1E4';
		$red       = '#E4D1D1';
		$orange    = '#E4DAD1';
		$yellow    = '#EEEADD';
		$white     = '#FFFFFF';

		add_theme_support(
			'editor-color-palette',
			array(
				array(
					'name'  => esc_html__( 'Black', 'twentytwentyone' ),
					'slug'  => 'black',
					'color' => $black,
				),
				array(
					'name'  => esc_html__( 'Dark gray', 'twentytwentyone' ),
					'slug'  => 'dark-gray',
					'color' => $dark_gray,
				),
				array(
					'name'  => esc_html__( 'Gray', 'twentytwentyone' ),
					'slug'  => 'gray',
					'color' => $gray,
				),
				array(
					'name'  => esc_html__( 'Green', 'twentytwentyone' ),
					'slug'  => 'green',
					'color' => $green,
				),
				array(
					'name'  => esc_html__( 'Blue', 'twentytwentyone' ),
					'slug'  => 'blue',
					'color' => $blue,
				),
				array(
					'name'  => esc_html__( 'Purple', 'twentytwentyone' ),
					'slug'  => 'purple',
					'color' => $purple,
				),
				array(
					'name'  => esc_html__( 'Red', 'twentytwentyone' ),
					'slug'  => 'red',
					'color' => $red,
				),
				array(
					'name'  => esc_html__( 'Orange', 'twentytwentyone' ),
					'slug'  => 'orange',
					'color' => $orange,
				),
				array(
					'name'  => esc_html__( 'Yellow', 'twentytwentyone' ),
					'slug'  => 'yellow',
					'color' => $yellow,
				),
				array(
					'name'  => esc_html__( 'White', 'twentytwentyone' ),
					'slug'  => 'white',
					'color' => $white,
				),
			)
		);

		add_theme_support(
			'editor-gradient-presets',
			array(
				array(
					'name'     => esc_html__( 'Purple to yellow', 'twentytwentyone' ),
					'gradient' => 'linear-gradient(160deg, ' . $purple . ' 0%, ' . $yellow . ' 100%)',
					'slug'     => 'purple-to-yellow',
				),
				array(
					'name'     => esc_html__( 'Yellow to purple', 'twentytwentyone' ),
					'gradient' => 'linear-gradient(160deg, ' . $yellow . ' 0%, ' . $purple . ' 100%)',
					'slug'     => 'yellow-to-purple',
				),
				array(
					'name'     => esc_html__( 'Green to yellow', 'twentytwentyone' ),
					'gradient' => 'linear-gradient(160deg, ' . $green . ' 0%, ' . $yellow . ' 100%)',
					'slug'     => 'green-to-yellow',
				),
				array(
					'name'     => esc_html__( 'Yellow to green', 'twentytwentyone' ),
					'gradient' => 'linear-gradient(160deg, ' . $yellow . ' 0%, ' . $green . ' 100%)',
					'slug'     => 'yellow-to-green',
				),
				array(
					'name'     => esc_html__( 'Red to yellow', 'twentytwentyone' ),
					'gradient' => 'linear-gradient(160deg, ' . $red . ' 0%, ' . $yellow . ' 100%)',
					'slug'     => 'red-to-yellow',
				),
				array(
					'name'     => esc_html__( 'Yellow to red', 'twentytwentyone' ),
					'gradient' => 'linear-gradient(160deg, ' . $yellow . ' 0%, ' . $red . ' 100%)',
					'slug'     => 'yellow-to-red',
				),
				array(
					'name'     => esc_html__( 'Purple to red', 'twentytwentyone' ),
					'gradient' => 'linear-gradient(160deg, ' . $purple . ' 0%, ' . $red . ' 100%)',
					'slug'     => 'purple-to-red',
				),
				array(
					'name'     => esc_html__( 'Red to purple', 'twentytwentyone' ),
					'gradient' => 'linear-gradient(160deg, ' . $red . ' 0%, ' . $purple . ' 100%)',
					'slug'     => 'red-to-purple',
				),
			)
		);

		/*
		* Adds starter content to highlight the theme on fresh sites.
		* This is done conditionally to avoid loading the starter content on every
		* page load, as it is a one-off operation only needed once in the customizer.
		*/
		if ( is_customize_preview() ) {
			require get_template_directory() . '/inc/starter-content.php';
			add_theme_support( 'starter-content', twenty_twenty_one_get_starter_content() );
		}

		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );

		// Add support for custom line height controls.
		add_theme_support( 'custom-line-height' );

		// Add support for link color control.
		add_theme_support( 'link-color' );

		// Add support for experimental cover block spacing.
		add_theme_support( 'custom-spacing' );

		// Add support for custom units.
		// This was removed in WordPress 5.6 but is still required to properly support WP 5.5.
		add_theme_support( 'custom-units' );

		// Remove feed icon link from legacy RSS widget.
		add_filter( 'rss_widget_feed_link', '__return_empty_string' );
	}
}
add_action( 'after_setup_theme', 'twenty_twenty_one_setup' );

/**
 * Registers widget area.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 *
 * @return void
 */
function twenty_twenty_one_widgets_init() {

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer', 'twentytwentyone' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'twentytwentyone' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'twenty_twenty_one_widgets_init' );

/**
 * Sets the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @global int $content_width Content width.
 *
 * @return void
 */
function twenty_twenty_one_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'twenty_twenty_one_content_width', 750 );
}
add_action( 'after_setup_theme', 'twenty_twenty_one_content_width', 0 );

/**
 * Enqueues scripts and styles.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @global bool       $is_IE
 * @global WP_Scripts $wp_scripts
 *
 * @return void
 */
function twenty_twenty_one_scripts() {
	// Note, the is_IE global variable is defined by WordPress and is used
	// to detect if the current browser is internet explorer.
	global $is_IE, $wp_scripts;
	if ( $is_IE ) {
		// If IE 11 or below, use a flattened stylesheet with static values replacing CSS Variables.
		wp_enqueue_style( 'twenty-twenty-one-style', get_template_directory_uri() . '/assets/css/ie.css', array(), wp_get_theme()->get( 'Version' ) );
	} else {
		// If not IE, use the standard stylesheet.
		wp_enqueue_style( 'twenty-twenty-one-style', get_template_directory_uri() . '/style.css', array(), wp_get_theme()->get( 'Version' ) );
	}

	// RTL styles.
	wp_style_add_data( 'twenty-twenty-one-style', 'rtl', 'replace' );

	// Print styles.
	wp_enqueue_style( 'twenty-twenty-one-print-style', get_template_directory_uri() . '/assets/css/print.css', array(), wp_get_theme()->get( 'Version' ), 'print' );

	// Threaded comment reply styles.
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// Register the IE11 polyfill file.
	wp_register_script(
		'twenty-twenty-one-ie11-polyfills-asset',
		get_template_directory_uri() . '/assets/js/polyfills.js',
		array(),
		wp_get_theme()->get( 'Version' ),
		array( 'in_footer' => true )
	);

	// Register the IE11 polyfill loader.
	wp_register_script(
		'twenty-twenty-one-ie11-polyfills',
		null,
		array(),
		wp_get_theme()->get( 'Version' ),
		array( 'in_footer' => true )
	);
	wp_add_inline_script(
		'twenty-twenty-one-ie11-polyfills',
		wp_get_script_polyfill(
			$wp_scripts,
			array(
				'Element.prototype.matches && Element.prototype.closest && window.NodeList && NodeList.prototype.forEach' => 'twenty-twenty-one-ie11-polyfills-asset',
			)
		)
	);

	// Main navigation scripts.
	if ( has_nav_menu( 'primary' ) ) {
		wp_enqueue_script(
			'twenty-twenty-one-primary-navigation-script',
			get_template_directory_uri() . '/assets/js/primary-navigation.js',
			array( 'twenty-twenty-one-ie11-polyfills' ),
			wp_get_theme()->get( 'Version' ),
			array(
				'in_footer' => false, // Because involves header.
				'strategy'  => 'defer',
			)
		);
	}

	// Responsive embeds script.
	wp_enqueue_script(
		'twenty-twenty-one-responsive-embeds-script',
		get_template_directory_uri() . '/assets/js/responsive-embeds.js',
		array( 'twenty-twenty-one-ie11-polyfills' ),
		wp_get_theme()->get( 'Version' ),
		array( 'in_footer' => true )
	);
}
add_action( 'wp_enqueue_scripts', 'twenty_twenty_one_scripts' );

/**
 * Enqueues block editor script.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @return void
 */
function twentytwentyone_block_editor_script() {

	wp_enqueue_script( 'twentytwentyone-editor', get_theme_file_uri( '/assets/js/editor.js' ), array( 'wp-blocks', 'wp-dom' ), wp_get_theme()->get( 'Version' ), array( 'in_footer' => true ) );
}

add_action( 'enqueue_block_editor_assets', 'twentytwentyone_block_editor_script' );

/**
 * Fixes skip link focus in IE11.
 *
 * This does not enqueue the script because it is tiny and because it is only for IE11,
 * thus it does not warrant having an entire dedicated blocking script being loaded.
 *
 * @since Twenty Twenty-One 1.0
 * @deprecated Twenty Twenty-One 1.9 Removed from wp_print_footer_scripts action.
 *
 * @link https://git.io/vWdr2
 */
function twenty_twenty_one_skip_link_focus_fix() {

	// If SCRIPT_DEBUG is defined and true, print the unminified file.
	if ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) {
		echo '<script>';
		include get_template_directory() . '/assets/js/skip-link-focus-fix.js';
		echo '</script>';
	} else {
		// The following is minified via `npx terser --compress --mangle -- assets/js/skip-link-focus-fix.js`.
		?>
		<script>
		/(trident|msie)/i.test(navigator.userAgent)&&document.getElementById&&window.addEventListener&&window.addEventListener("hashchange",(function(){var t,e=location.hash.substring(1);/^[A-z0-9_-]+$/.test(e)&&(t=document.getElementById(e))&&(/^(?:a|select|input|button|textarea)$/i.test(t.tagName)||(t.tabIndex=-1),t.focus())}),!1);
		</script>
		<?php
	}
}

/**
 * Enqueues non-latin language styles.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @return void
 */
function twenty_twenty_one_non_latin_languages() {
	$custom_css = twenty_twenty_one_get_non_latin_css( 'front-end' );

	if ( $custom_css ) {
		wp_add_inline_style( 'twenty-twenty-one-style', $custom_css );
	}
}
add_action( 'wp_enqueue_scripts', 'twenty_twenty_one_non_latin_languages' );

// SVG Icons class.
require get_template_directory() . '/classes/class-twenty-twenty-one-svg-icons.php';

// Custom color classes.
require get_template_directory() . '/classes/class-twenty-twenty-one-custom-colors.php';
new Twenty_Twenty_One_Custom_Colors();

// Enhance the theme by hooking into WordPress.
require get_template_directory() . '/inc/template-functions.php';

// Menu functions and filters.
require get_template_directory() . '/inc/menu-functions.php';

// Custom template tags for the theme.
require get_template_directory() . '/inc/template-tags.php';

// Customizer additions.
require get_template_directory() . '/classes/class-twenty-twenty-one-customize.php';
new Twenty_Twenty_One_Customize();

// Block Patterns.
require get_template_directory() . '/inc/block-patterns.php';

// Block Styles.
require get_template_directory() . '/inc/block-styles.php';

// Dark Mode.
require_once get_template_directory() . '/classes/class-twenty-twenty-one-dark-mode.php';
new Twenty_Twenty_One_Dark_Mode();

/**
 * Enqueues scripts for the customizer preview.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @return void
 */
function twentytwentyone_customize_preview_init() {
	wp_enqueue_script(
		'twentytwentyone-customize-helpers',
		get_theme_file_uri( '/assets/js/customize-helpers.js' ),
		array(),
		wp_get_theme()->get( 'Version' ),
		array( 'in_footer' => true )
	);

	wp_enqueue_script(
		'twentytwentyone-customize-preview',
		get_theme_file_uri( '/assets/js/customize-preview.js' ),
		array( 'customize-preview', 'customize-selective-refresh', 'jquery', 'twentytwentyone-customize-helpers' ),
		wp_get_theme()->get( 'Version' ),
		array( 'in_footer' => true )
	);
}
add_action( 'customize_preview_init', 'twentytwentyone_customize_preview_init' );

/**
 * Enqueues scripts for the customizer.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @return void
 */
function twentytwentyone_customize_controls_enqueue_scripts() {

	wp_enqueue_script(
		'twentytwentyone-customize-helpers',
		get_theme_file_uri( '/assets/js/customize-helpers.js' ),
		array(),
		wp_get_theme()->get( 'Version' ),
		array( 'in_footer' => true )
	);
}
add_action( 'customize_controls_enqueue_scripts', 'twentytwentyone_customize_controls_enqueue_scripts' );

/**
 * Calculates classes for the main <html> element.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @return void
 */
function twentytwentyone_the_html_classes() {
	/**
	 * Filters the classes for the main <html> element.
	 *
	 * @since Twenty Twenty-One 1.0
	 *
	 * @param string The list of classes. Default empty string.
	 */
	$classes = apply_filters( 'twentytwentyone_html_classes', '' );
	if ( ! $classes ) {
		return;
	}
	echo 'class="' . esc_attr( $classes ) . '"';
}

/**
 * Adds "is-IE" class to body if the user is on Internet Explorer.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @return void
 */
function twentytwentyone_add_ie_class() {
	?>
	<script>
	if ( -1 !== navigator.userAgent.indexOf( 'MSIE' ) || -1 !== navigator.appVersion.indexOf( 'Trident/' ) ) {
		document.body.classList.add( 'is-IE' );
	}
	</script>
	<?php
}
add_action( 'wp_footer', 'twentytwentyone_add_ie_class' );

if ( ! function_exists( 'wp_get_list_item_separator' ) ) :
	/**
	 * Retrieves the list item separator based on the locale.
	 *
	 * Added for backward compatibility to support pre-6.0.0 WordPress versions.
	 *
	 * @since 6.0.0
	 */
	function wp_get_list_item_separator() {
		/* translators: Used between list items, there is a space after the comma. */
		return __( ', ', 'twentytwentyone' );
	}
endif;


//ACF theme settings

if( function_exists('acf_add_options_page') ) {

    acf_add_options_page(array(
        'page_title'    => 'Theme General Settings',
        'menu_title'    => 'Theme Settings',
        'menu_slug'     => 'theme-general-settings',
        'capability'    => 'edit_posts',
        'redirect'      => false
    ));

    acf_add_options_sub_page(array(
        'page_title'    => 'Theme Header Settings',
        'menu_title'    => 'Header',
        'parent_slug'   => 'theme-general-settings',
    ));

    acf_add_options_sub_page(array(
        'page_title'    => 'Theme Footer Settings',
        'menu_title'    => 'Footer',
        'parent_slug'   => 'theme-general-settings',
    ));

}


//Upload SVG Images Code
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
	$filetype = wp_check_filetype( $filename, $mimes );
  return [
		'ext'             => $filetype['ext'],
		'type'            => $filetype['type'],
		'proper_filename' => $data['proper_filename']
	];
  
  }, 10, 4 );
  function cc_mime_types( $mimes ){
	$mimes['svg'] = 'image/svg+xml';
  return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  function fix_svg() {
  echo '<style type="text/css">
		  .attachment-266x266, .thumbnail img {
  width: 100% !important;
  height: auto !important;
		  }
  </style>';
  }
  add_action( 'admin_head', 'fix_svg' );


//remove <p> contact form
add_filter('wpcf7_autop_or_not', '__return_false');



function enqueue_custom_scripts() {
    wp_enqueue_script('jquery');
}
add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');





//Faq Search
function search_faq_ajax_handler() {
    $search_query = sanitize_text_field($_POST['search_query']);
    $page_id = intval($_POST['page_id']); // Retrieve page ID from AJAX request

    ob_start(); // Start output buffering

	

    if( have_rows('faq', $page_id) ) : // Ensure the repeater field 'faq' exists for the specified page
        
        $i = 1; while( have_rows('faq', $page_id) ) : the_row();
            $question = get_sub_field('question'); // Ensure this is the correct field name
            $answer = get_sub_field('answer'); // Ensure this is the correct field name

            // Check if the search query matches the question or answer
            if( stripos($question, $search_query) !== false || stripos($answer, $search_query) !== false ) :
                ?>

				<?php

				$active_class = ($i === 1) ? 'active' : '';
				$style = ($i === 1) ? 'block' : '';

				?>

				<li class="<?php echo $active_class; ?>">
					<h5><?php echo get_sub_field('question'); ?></h5>

					<div class="content" style="display: <?php echo $style; ?>;">
						<p><?php echo get_sub_field('answer'); ?></p>
					</div>
				</li>

                
                <?php
            endif;
        $i++; endwhile;
    else :
        ?>
        
        <?php
    endif;

	
	

    $output = ob_get_clean(); // Get the buffered content
    echo $output; // Echo the buffered content

    wp_die(); // Use wp_die() instead of die() to properly end the AJAX request in WordPress
}

add_action('wp_ajax_search_faq', 'search_faq_ajax_handler');
add_action('wp_ajax_nopriv_search_faq', 'search_faq_ajax_handler');





//Hide admin bar
function admin_bar() {
    if (is_user_logged_in() && current_user_can('administrator')) {
        add_filter('show_admin_bar', '__return_true', 1000);
    } else {
        add_filter('show_admin_bar', '__return_false', 1000);
    }
}
add_action('init', 'admin_bar');




// Check if email exists
add_action('wp_ajax_check_email_exists', 'check_email_exists');
add_action('wp_ajax_nopriv_check_email_exists', 'check_email_exists');

function check_email_exists() {
    global $wpdb;
    $email = sanitize_email($_POST['email']);
    $table_name = $wpdb->prefix . 'users';

    $query = $wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE user_email = %s", $email);
    $result = $wpdb->get_var($query);

    if ($result > 0) {
        wp_send_json(['message' => 'exists']);
    } else {
        wp_send_json(['message' => 'not exists']);
    }

    wp_die();
}

// Handle user registration
add_action('wp_ajax_create_your_subscriber_account', 'create_your_subscriber_account');
add_action('wp_ajax_nopriv_create_your_subscriber_account', 'create_your_subscriber_account');

function create_your_subscriber_account() {
    $email = sanitize_email($_POST['cemail']);
    $fullname = sanitize_text_field($_POST['fullName']);
    $password = sanitize_text_field($_POST['cpw']);

    $name_parts = explode(' ', $fullname);
    $firstname = $name_parts[0];
    $lastname = isset($name_parts[1]) ? $name_parts[1] : '';

    // Ensure the email does not exist
    if (email_exists($email)) {
        wp_send_json_error(['message' => 'exists']);
    }

    $email_parts = explode('@', $email);
    $username = $email_parts[0];

    // Register the user
    $userdata = array(
        'user_login' => $username,
        'user_email' => $email,
        'user_pass' => $password,
        'first_name' => $firstname,
        'last_name' => $lastname,
        'role' => 'customer'
    );

    $user_id = wp_insert_user($userdata);

    if (!is_wp_error($user_id)) {
        // Log in the user and redirect
        wp_set_current_user($user_id);
        wp_set_auth_cookie($user_id);

        wp_send_json_success(['message' => 'success']);
    } else {
        wp_send_json_error(['message' => 'error']);
    }

    wp_die();
}







//login

add_action('wp_ajax_user_log_in', 'user_log_in');
add_action('wp_ajax_nopriv_user_log_in', 'user_log_in');
function user_log_in() {

	global $wpdb;
	global $current_user;
	error_reporting(E_ALL);
    ini_set('display_errors',1);
 	$user_login = $_POST['user_login'];
  	$user_password = $_POST['user_password'];
  	$redirecturl = "";
  	$credentials = array(
        'user_login'    => $user_login,
        'user_password' => $user_password
    );
    $user = wp_signon( $credentials, false);
    

    //---newly added end ---

    if( empty( $user_login ) ) {
		//echo 'Username field is required.';
		echo json_encode(array('loggedin'=>false, 'message'=>__('Username field is required.')));
	} 
	else if( empty( $user_password) ) {
		//echo 'Password field is required.';
		echo json_encode(array('loggedin'=>false, 'message'=>__('Password field is required.')));
	} 
	else {
		if ( is_wp_error($user) ) {
			$error = $user->get_error_message();
			echo json_encode(array('loggedin'=>false, 'message'=>__('Wrong credentials. Please enter correct credentials.')));
			//echo "Wrong credentials. Please given correct credentials.";
		}else {
			set_current_user( $user->ID, $user_login );
			
			$user = wp_get_current_user();

			$table_link = $wpdb->prefix .'users';
                    $query_coach = $wpdb->prepare("SELECT * FROM $table_link WHERE  ID =$user->ID");
                    $results_coach = $wpdb->get_results($query_coach); 
				    $user_status = $results_coach[0]->user_status;
				    if($user_status==1)
				    {
				        $redirecturl = site_url('/');
				    }
				    else
				    {
				        $redirecturl = site_url('/');
				    }
				    
				    //echo "Login Successfully, Please wait...";
				    //echo $response;
				    echo json_encode(array('loggedin'=>true, 'succmessage'=>__('Login successful, redirecting...'),'redirecturl'=>$redirecturl));
				    //return site_url('/staff-dashboard/');
				    //echo json_encode($response); // Echo the response
				
			
		}
	} 
	wp_die();
}





//forgot-password
add_action('wp_ajax_nopriv_coach_fpw', 'coach_fpw');
add_action('wp_ajax_coach_fpw', 'coach_fpw');
function coach_fpw(){

    global $wpdb;
  $email  =  $_POST['user_login'];

    $name = $wpdb->get_var("SELECT `ID` FROM `wp_users` WHERE `user_email` = '".$email."'");
    // $first_name = get_user_meta( $current_user_id, $name, 'false' ); 
    // $last_name = get_user_meta( $current_user_id, $name, 'false' );  
	// $fullnm = $first_name .' '.$last_name;
	
	if(get_user_by( "email", $email )) {

		$userdata=get_user_by( "email", $email );
		$subject = "Password Reset ";
	    $user = get_user_by( 'email', $email );
		$key = get_password_reset_key( $user );
		
		$reset_url = esc_url_raw(
    		add_query_arg(
    			array(
    				'cusresetpass' => 'true',
    				'cusfrp_action' => 'rp',
    				'key' => $key,
    				'uid' => $email
    			),
    			get_permalink( get_page_by_path( 'reset-password' ) )
    		)
    	);
        $eml_nw = $email;
    	$message = '<html> <body>';
	    $message .= '<span style="padding: 25px 50px;background: #f1f1f1;display: block;">';
		$message .=	'<p style="color: #555;font-family: Arial;font-size: 15px;font-weight: 600">Hello '.$fullnm.',</p>';
		$message .=	'<p style="color: #333;font-family: Arial;font-size: 17px;margin-top: 7px;">We’ve received a request to reset your password for the account associated with '.$email.' </p>';
		$message .=	'<p style="color: #333;font-family: Arial;font-size: 17px;margin-top: 7px;">You can reset your password by clicking on the “Reset Password” button below.</p>';
		$message .=	'<p style="color: #333;font-family: Arial;font-weight: 500;font-size: 17px;margin-top: 5px;"><a href="'.$reset_url.'" style="padding: 8px 25px;background:#37af72;color: #fff;text-decoration: none;display: inline-block;font-size: 18px;border-radius: 5px;">Reset Password</a> 
			</p> </span>';
		$message .=	'</body> </html>';

    	$headers = "MIME-Version: 1.0" . "\r\n";
		$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
		$headers .= "From: test@example.com" . "\r\n";
    	
        wp_mail($eml_nw, $subject, $message, $headers);
		
		$msg="<p style='color:#9FCC3B;font-size:16px;font-weight:600;margin-bottom: 20px;'>An email with the instructions to reset your password has been sent to $email.</p>";
		$tf = true;
	}
	else {
		$msg="<p style='color:Red;font-size:16px;font-weight:600;'>Sorry, this user is not registered. </p>";
		$tf = false;
	}

    wp_die(json_encode(array('loggedin' => $tf, 'message' => $msg)));


}







//reset-password

add_action('wp_ajax_nopriv_reset_npassword', 'reset_npassword');

add_action('wp_ajax_reset_npassword', 'reset_npassword');

function reset_npassword(){

    
    global $wpdb;

    echo $user_id    =  $_POST['uid']; 
   	echo $new_password  =  $_POST['repass'];
    
    
    wp_set_password( $new_password, $user_id );
	
	clean_user_cache($user_id);
    wp_clear_auth_cookie();
    // wp_set_current_user($user_id);
    // wp_set_auth_cookie($user_id, true, false);
        
    $user = get_user_by('id', $user_id);
    update_user_caches($user);
    
    echo 'true';
    // wp_die();

}




// Woocommerce support
function mytheme_add_woocommerce_support() {
    add_theme_support('woocommerce');
}

add_action('after_setup_theme', 'mytheme_add_woocommerce_support');



//woocommerce

//remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
// add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 25 );




//add to cart
add_action( 'woocommerce_before_quantity_input_field', 'bbloomer_display_quantity_minus' );
 
function bbloomer_display_quantity_minus() {
   if ( ! is_product() ) return;
   echo '<button type="button" class="minus" >-</button>';
}
 
add_action( 'woocommerce_after_quantity_input_field', 'bbloomer_display_quantity_plus' );
 
function bbloomer_display_quantity_plus() {
   if ( ! is_product() ) return;
   echo '<button type="button" class="plus" >+</button>';
}
 
add_action( 'woocommerce_before_single_product', 'bbloomer_add_cart_quantity_plus_minus' );
 
function bbloomer_add_cart_quantity_plus_minus() {
   wc_enqueue_js( "
      $('form.cart').on( 'click', 'button.plus, button.minus', function() {
            var qty = $( this ).closest( 'form.cart' ).find( '.qty' );
            var val   = parseFloat(qty.val());
            var max = parseFloat(qty.attr( 'max' ));
            var min = parseFloat(qty.attr( 'min' ));
            var step = parseFloat(qty.attr( 'step' ));
            if ( $( this ).is( '.plus' ) ) {
               if ( max && ( max <= val ) ) {
                  qty.val( max );
               } else {
                  qty.val( val + step );
               }
            } else {
               if ( min && ( min >= val ) ) {
                  qty.val( min );
               } else if ( val > 1 ) {
                  qty.val( val - step );
               }
            }
         });
   " );
}
add_filter('woocommerce_order_item_display_meta_value', function($meta_value, $meta, $item) {
  // Remove wrapping <p> tags
  $meta_value = preg_replace('/^<p[^>]*>|<\/p>$/i', '', $meta_value);
  return $meta_value;
}, 10, 3);


// Woo hooks Styles.
require get_template_directory() . '/inc/woo-hooks.php';
add_filter( 'acf/settings/remove_wp_meta_box', '__return_false' );
// Disable Ready Only for Administrators
// add_filter( 'acf/load_field', 'yanco_acf_disable_read_only', 10000 );
function yanco_acf_disable_read_only( $field ) {

    // Applies to administrators
    if( is_admin() && get_post_type() == 'afrapportering' ) {
        global $pagenow;
        
        if( $pagenow !== 'post-new.php' ) {
            $current_user = wp_get_current_user();
            $user_id = $current_user->ID;
            
            if( yanco_user_has_role( $user_id, 'administrator' ) ) {
                $field['required'] = false;
                $field['readonly'] = false;
            }
        }
    }
	
	return $field;
}

add_action('acf/input/admin_head', 'yanco_acf_admin_head');
function yanco_acf_admin_head() {

    if( is_admin() && get_post_type() == 'afrapportering' ) {
        global $pagenow;
        
        if( $pagenow !== 'post-new.php' ) {
            $current_user = wp_get_current_user();
            $user_id = $current_user->ID;
            
            if( yanco_user_has_role( $user_id, 'administrator' ) ) {
                
                echo '<script type="text/javascript">
                    window.acf.validation.active = false;
                </script>';
            }
        }
    }
}

add_action('acf/validate_save_post', 'yanco_acf_validate_save_post', 10, 0);
function yanco_acf_validate_save_post() {

    if( is_admin() && get_post_type() == 'afrapportering' ) {
        global $pagenow;
        
        if( $pagenow !== 'post-new.php' ) {
            $current_user = wp_get_current_user();
            $user_id = $current_user->ID;
            
            if( yanco_user_has_role( $user_id, 'administrator' ) ) {
                acf_reset_validation_errors();
            }
        }
    }
}