<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> <?php twentytwentyone_the_html_classes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />

	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/images/fav-icon.svg">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/owl.carousel.min.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/owl.theme.default.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/slimNav_sk78.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/style.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/responsive.css">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<header>
    <div class="top-header-part">
        <div class="container">
            <div class="content-wraper">
                <div class="logo-wraper">

					<?php 
						$header_logo = get_field('header_logo', 'option'); 
						$header_logo_alt = ($header_logo['alt']) ? ($header_logo['alt']) : ($header_logo['title']);
					?>
                    <a href="<?php echo get_site_url(); ?>"><img src="<?php echo esc_url($header_logo['url']); ?>" alt="<?php echo $header_logo_alt; ?>"></a>
                </div>
                <div class="sub-wraper-content">
                    <div class="search-wraper">

                        <?php echo do_shortcode('[aws_search_form]'); ?>

                        <!-- <form action="">
                            <input type="search" name="" id="" placeholder="Search Products...">
                            <input type="submit" value="">
                        </form> -->

                    </div>
                    <div class="left-content-wraper">
                        <ul class="for-desktop">
                            <li>
								<?php echo get_field('question', 'option'); ?>
                            </li>


                            <li>
                                <?php if ( is_user_logged_in() ) { ?>

                                    <a href="<?php echo wp_logout_url( home_url() ); ?>">Logout</a>
                                    <a href="<?php echo get_site_url(); ?>/my-account/"><span>My Account</span></a>

                                <?php } else { ?>

                                    <a href="<?php echo get_site_url(); ?>/log-in/">Log In</a>
                                    <a href="<?php echo get_site_url(); ?>/log-in/"><span>My Account</span></a>

                                <?php } ?>                                
                            </li>


                        </ul>
                        <ul class="for-mobile">
                            <li><a href="#?"><i class="fa-solid fa-phone"></i></a></li>
                            <li><a href="login.php"><i class="fa-solid fa-user"></i></a></li>
                            <li><a href="#?"><i class="fa-solid fa-cart-shopping"></i></a></li>
                        </ul>
                        <div class="cart">
                            <div class="img-wraper">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/cart-icon.svg" alt="">

                                <?php
                                    // Get the cart count
                                    $cart_count = WC()->cart->get_cart_contents_count();
                                    
                                    // Display the cart count if it's not zero
                                    if ($cart_count > 0) {
                                        echo '<span>' . $cart_count . '</span>';
                                    }else {
                                        echo '<span>0</span>';
                                    }
                                ?>
                                
                            </div>

                            <h6>Cart</h6>
                            <a href="<?php echo get_site_url(); ?>/cart/" class=pabs></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="bottom-header-part">
        <div class="container">

            <div id="navigation">
                <nav>
                    <div class="main-menu">
<?php wp_nav_menu( array( 'theme_location' => 'max_mega_menu_1' ) ); ?>
</div>
                </nav>
            </div>
        </div>
    </div>
</header>