<?php 

function custom_add_woocommerce_support() {
    add_theme_support('woocommerce');
}
add_action('after_setup_theme', 'custom_add_woocommerce_support');
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20);
add_action('woocommerce_before_single_product_summary', 'custom_woocommerce_product_gallery', 20);

function custom_woocommerce_product_gallery() {
    global $product;
    $attachment_ids = $product->get_gallery_image_ids();
    $main_image_id = $product->get_image_id();
    $main_image_url = wp_get_attachment_image_url($main_image_id, 'large');
    ?>
    <div class="slider-container">
        <!-- Thumbnail Carousel -->
        <div class="thumb-carousel owl-carousel">
            <?php
            echo '<div class="thumb active" data-slide="0"><img src="' . esc_url($main_image_url) . '" alt="Main Thumb"></div>';
            foreach ($attachment_ids as $index => $attachment_id) {
                $thumb_url = wp_get_attachment_image_url($attachment_id, 'thumbnail');
                echo '<div class="thumb" data-slide="' . esc_attr($index + 1) . '"><img src="' . esc_url($thumb_url) . '" alt="Thumb ' . ($index + 2) . '"></div>';
            }
            ?>
        </div>

        <!-- Main Carousel -->
        <div class="main-carousel owl-carousel">
            <div class="item"><img src="<?php echo esc_url($main_image_url); ?>" alt="Main Image"></div>
            <?php
            foreach ($attachment_ids as $attachment_id) {
                $img_url = wp_get_attachment_image_url($attachment_id, 'large');
                echo '<div class="item"><img src="' . esc_url($img_url) . '" alt="Gallery Image"></div>';
            }
            ?>
        </div>
    </div>
    <?php
}

function custom_enqueue_owl_assets() {
    if (is_product()) {
        wp_enqueue_style('owl-carousel', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css');
        wp_enqueue_script('owl-carousel', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js', ['jquery'], null, true);
        wp_add_inline_script('owl-carousel', "
            jQuery(document).ready(function($) {
                $('.main-carousel').owlCarousel({
                    items: 1,
                    nav: true,
                    dots: false,
                    loop: true,
                    autoplay: false,
                });
                $('.thumb-carousel .thumb').on('click', function() {
                    var index = $(this).data('slide');
                    $('.main-carousel').trigger('to.owl.carousel', [index, 300]);
                    $('.thumb').removeClass('active');
                    $(this).addClass('active');
                });
            });
        ");
    }
}
add_action('wp_enqueue_scripts', 'custom_enqueue_owl_assets');
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );

remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 20);
add_action('woocommerce_single_product_summary', 'custom_woocommerce_price_for_customize_product', 25);


function custom_woocommerce_price_for_customize_product() {
    global $product;

    // Check if product type is 'customize_product'
    if ($product && $product->get_type() === 'customize_product') {
        $price_html = $product->get_price_html();

        if ($price_html) {
            echo '<h4 class="custom-price">Starting From: ' . $price_html . '</h4>';
        }
    } else {
        // fallback to default price for other types
        woocommerce_template_single_price();
    }
}

// Add custom column for rating in the admin review list
add_filter('manage_edit-comments_columns', 'add_rating_column_to_reviews', 20);
function add_rating_column_to_reviews($columns) {
    if (isset($_GET['post_type']) && $_GET['post_type'] === 'product') {
        $columns['rating'] = __('Rating', 'woocommerce');
    }
    return $columns;
}

// Populate the custom column with star rating
add_action('manage_comments_custom_column', 'show_star_rating_in_admin_reviews', 10, 2);
function show_star_rating_in_admin_reviews($column, $comment_ID) {
    if ($column === 'rating') {
        $rating = get_comment_meta($comment_ID, 'rating', true);
        if ($rating) {
            for ($i = 1; $i <= 5; $i++) {
                echo $i <= $rating ? '★' : '☆';
            }
        } else {
            echo '—';
        }
    }
}
add_action('admin_head', function() {
    echo '<style>
        .column-rating { width: 100px; text-align: center; }
        .column-rating span { font-size: 16px; color: #FFD700; }
        #woocommerce-rating{display: none !important;}
    </style>';
});
add_action('add_meta_boxes_comment', 'add_admin_rating_meta_box');
function add_admin_rating_meta_box() {
    $screen = get_current_screen();
  //  if (isset($_GET['post_type']) && $_GET['post_type'] === 'product' || $screen->post_type === 'product') {
        add_meta_box('title', __('Review Rating', 'woocommerce'), 'render_admin_review_rating', 'comment', 'normal', 'high');
  //  }
}

function render_admin_review_rating($comment) {
    $rating = get_comment_meta($comment->comment_ID, 'rating', true);
    ?>
    <label for="admin_review_rating"><?php _e('Rating', 'woocommerce'); ?>:</label>
    <select name="admin_review_rating" id="admin_review_rating">
        <option value=""><?php _e('No rating', 'woocommerce'); ?></option>
        <?php for ($i = 1; $i <= 5; $i++) : ?>
            <option value="<?php echo $i; ?>" <?php selected($rating, $i); ?>>
                <?php echo $i; ?> Star<?php echo $i > 1 ? 's' : ''; ?>
            </option>
        <?php endfor; ?>
    </select>
    <?php
}
add_action('edit_comment', 'save_admin_review_rating');
add_action('comment_post', 'save_admin_review_rating');
function save_admin_review_rating($comment_id) {
    if (isset($_POST['admin_review_rating'])) {
        $rating = intval($_POST['admin_review_rating']);
        if ($rating >= 1 && $rating <= 5) {
            update_comment_meta($comment_id, 'rating', $rating);
        } else {
            delete_comment_meta($comment_id, 'rating');
        }
    }
}
remove_action( 'woocommerce_proceed_to_checkout', 'woocommerce_button_proceed_to_checkout', 20 );
add_filter( 'woocommerce_proceed_to_checkout', 'custom_proceed_to_checkout_button', 10 );

function custom_proceed_to_checkout_button() {
    $checkout_url = wc_get_checkout_url();

    echo '<a href="' . esc_url( $checkout_url ) . '" class="green-btn">';
    esc_html_e( 'Proceed to Checkout', 'woocommerce' );
    echo '</a>';
}
