<?php
/**
* Template Name: Desk Plate
*
*/

get_header();

?>


<section class="inner-banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1><?php echo get_the_title(); ?></h1>
                <ul>
                    <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                    <li><?php echo get_the_title(); ?></li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="desk-plate-sec1">
    <div class="container">
        <div class="row">

            <?php if(have_rows('section_1_box')) : ?>
            <?php $i = 1; while(have_rows('section_1_box')) : the_row(); ?>

            <div class="col-lg-6 col-md-6">
                <div class="cart-item">
                    <?php echo get_sub_field('content'); ?>

                    <?php 
                        $button = get_sub_field('button'); 
                        if( $button ): 
                            $link_url = $button['url'];
                            $link_title = $button['title']; 
                            $link_target = $button['target'] ? $button['target'] : '_self'; 
                    ?>
                    <a href="<?php echo esc_url(  $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="green-btn"><?php echo esc_html( $link_title ); ?></a>
                    <?php endif; ?>


                    <?php 
                        $image = get_sub_field('image'); 
                        $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                    ?>

                    <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="dp-cart<?php echo $i; ?>-img">
                    
                    <span class="circle"></span>
                </div>
            </div>

            <?php $i++; endwhile; endif; ?>

        </div>
    </div>
</section>

<section class="desk-plate-sec2">
    <?php if(have_rows('section_2')) : ?>
    <?php while(have_rows('section_2')) : the_row(); ?>

    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-md-7">

                <?php echo get_sub_field('content'); ?>                
                
                <div class="grid-box">

                    <?php if(have_rows('points')) : ?>
                    <?php while(have_rows('points')) : the_row(); ?>

                    <div class="grid-content">
                        <?php echo get_sub_field('point'); ?>
                    </div>

                    <?php endwhile; endif; ?>
                </div>
            </div>
            <div class="col-lg-5 col-md-5 ms-auto">
                <?php 
                    $image = get_sub_field('image'); 
                    $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                ?>

                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="main-img">
            </div>
        </div>
    </div>

    <?php endwhile; endif; ?>
</section>

<section class="desk-plate-sec3">
    <div class="container">

        <?php if(have_rows('zigzag_section')) : ?>
        <?php while(have_rows('zigzag_section')) : the_row(); ?>

        <div class="row align-items-lg-center">
            <div class="col-lg-6 col-md-5">
                <?php 
                    $image = get_sub_field('image'); 
                    $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                ?>

                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="site-img">
            </div>
            <div class="col-lg-6 col-md-7">
            <?php echo get_sub_field('content'); ?>
                
                <?php 
                    $button = get_sub_field('button'); 
                    if( $button ): 
                        $link_url = $button['url'];
                        $link_title = $button['title']; 
                        $link_target = $button['target'] ? $button['target'] : '_self'; 
                ?>
                <a href="<?php echo esc_url(  $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="green-btn"><?php echo esc_html( $link_title ); ?></a>
                <?php endif; ?>
            </div>
        </div>

        <?php endwhile; endif; ?>
    </div>
</section>



<?php
get_footer();
?>
