<?php
/**
* Template Name: FAQ
*
*/

get_header();

?>


<section class="inner-banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1><?php echo get_the_title(); ?></h1>
                <ul>
                    <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                    <li><?php echo get_the_title(); ?></li>
                </ul>
            </div>
        </div>
    </div>
</section>


<section class="faq-sec1">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="form-wraper">



                    <form role="search" method="get" id="faq-search-form" action="">
                        <input type="hidden" name="page-id" value="<?php echo get_the_ID(); ?>">
                        <input type="search" name="faq-search" id="faq-search" placeholder="Search">
                        <input type="submit" value="">
                    </form>

                </div>

                <ul class="accordian " id="faq-results">

                    <?php if(have_rows('faq')) : ?>
                    <?php $i = 1; while(have_rows('faq')) : the_row(); ?>

                    <?php

                        $active_class = ($i === 2) ? 'active' : '';
                        $style = ($i === 2) ? 'block' : '';

                    ?>

                    <li class="<?php echo $active_class; ?>">
                        <h5><?php echo get_sub_field('question'); ?></h5>

                        <div class="content" style="display: <?php echo $style; ?>;">
                            <p><?php echo get_sub_field('answer'); ?></p>
                        </div>
                    </li>

                    <?php $i++; endwhile; endif; ?>

                </ul>
            </div>
        </div>
    </div>
</section>



<?php
get_footer();
?>


<script>
jQuery(document).ready(function($) {

    // Define toggle functionality
    function bindFaqToggle() {
        $('#faq-results li h5').off('click').on('click', function() {
            var $this = $(this);
            var $li = $this.closest('li');
            var $content = $this.next('.content');

            // Toggle logic
            if ($li.hasClass('active')) {
                $li.removeClass('active');
                $content.slideUp();
            } else {
                $('#faq-results li').removeClass('active');
                $('#faq-results .content').slideUp();

                $li.addClass('active');
                $content.slideDown();
            }
        });
    }

    // Initial bind
    bindFaqToggle();

    // Handle AJAX form submission
    $('#faq-search-form').submit(function(event) {
        event.preventDefault();

        var searchQuery = $('input[name="faq-search"]').val();
        var pageID = $('input[name="page-id"]').val();

        $.ajax({
            type: 'POST',
            url: "<?php echo admin_url('admin-ajax.php'); ?>",
            data: {
                action: 'search_faq',
                search_query: searchQuery,
                page_id: pageID
            },
            success: function(response) {
                $('#faq-results').html(response);
                bindFaqToggle(); // Re-bind toggle after content is updated
            },
            error: function(xhr, status, error) {
                console.log("AJAX error: " + status + ' - ' + error);
            }
        });
    });
});
</script>
