<?php
/**
* Template Name: Forgot password
*
*/

if(is_user_logged_in()){ 
	
	$user = wp_get_current_user();
    $redirecturl = site_url('/');
    wp_safe_redirect($redirecturl);	
	
 }


get_header();

?>


<section class="inner-banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1><?php echo get_the_title(); ?></h1>
                <ul>
                    <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                    <li><?php echo get_the_title(); ?></li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="loginAndsignup-sec">
    <div class="container">
        <div class="row align-items-lg-center">
            <div class="col-lg-6 col-md-7">
                <h2>Enter Registered Email Address</h2>
                <div class="form-wraper">

                    <form method="POST" action="" id="forgot_pass_form" name="forgetpass-form">

                        <label for="">Email</label>
                        <input type="email" name="email" id="username" placeholder="Johnsmith@gmail.com" required>


                        <input type="submit" id="forget_pass_btn" value="Submit" class="green-btn">

                    </form>

                    <div id="succ_msg" style="color:#9FCC3B;margin-bottom: 20px;"></div>
                    <div id="error_msg" style="color:Red;margin-bottom: 20px;"></div>


                    <p>Want to go back? <a href="<?php echo get_site_url(); ?>/log-in">Back</a></p>
                </div>
            </div>
            <div class="col-lg-6 col-md-5">
                <?php 
                    $image = get_field('login_page_image', 'option'); 
                    $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                ?>

                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="login-img">
            </div>
        </div>
    </div>
</section>





<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.js"></script>

<script>

//login
jQuery('#forget_pass_btn').on('click', function(e) {

    e.preventDefault();
    var email = jQuery("#username").val();
            var emailRegex = /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i;
            
            if (email != "" && emailRegex.test(email)) {
                // alert(email)

                // Perform AJAX request to check if the email exists
                jQuery.ajax({
                    url: "<?php echo admin_url('admin-ajax.php'); ?>",
                    type: "POST",
                    
                    data: {
                        action: 'check_email_exists',
                        email: email
                    },
                    success: function(response) {
                        // alert(response.message);
                        if (response.message != "exists") {
                            // Email exists, show error message or handle accordingly
                            alert("Email does not exist!");
                            
                        } else {
                                    
                                   
                                        var userName = jQuery('#username').val();
                                        // alert(userName);
                                        jQuery.ajax({
                                            type: "POST",
                                            dataType: 'json',
                                            url: "<?php echo admin_url('admin-ajax.php'); ?>",
                                            dataType: "json",
                                            data: {
                                                action: "coach_fpw",
                                                user_login: userName,
                                            
                                            },
                                            beforeSend: function() {
                                                jQuery('#succ_msg').html('Please Wait...').show();

          },
                                           


                                            success: function(data) {
                                            //    alert(data);
                                                console.log(data.message);

                                                    if (data.loggedin == true) {
                                                        jQuery('#error_msg').html(data.message).hide();
                                                        jQuery('#succ_msg').html(data.message).show();
                                                        // window.location.href = data.redirecturl;
                                                    }
                                                    else {

                                                        jQuery('#error_msg').html(data.message).show();
                                                        jQuery('#succ_msg').html(data.message).hide();

                                                    }

                                            

                                            },
                                            error: function(data) {

                                            }
                                        });

                        }
                    }
                });
           
            }else{
                jQuery('#error_msg').html('<p style="color:Red;font-size:16px;font-weight:600;">Sorry, Please Enter A Proper email.</p>').show();
            }



	
});
</script>

<?php
get_footer();
?>

