<?php
/**
* Template Name: Login
*
*/

if(is_user_logged_in()){ 
	
	$user = wp_get_current_user();

    
    $redirecturl = site_url('/');
	   wp_safe_redirect($redirecturl);

	
}

get_header();

?>

<section class="inner-banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1><?php echo get_the_title(); ?></h1>
                <ul>
                    <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                    <li><?php echo get_the_title(); ?></li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="loginAndsignup-sec">
    <div class="container">
        <div class="row align-items-lg-center">
            <div class="col-lg-6 col-md-7">
                <h2>Welcome Back</h2>
                <div class="form-wraper">

                    <form method="POST" action="" id="login_form" name="login-form">

                        <label for="">Email</label>
                        <input type="email" name="email" id="username" placeholder="Johnsmith@gmail.com">

                        <label for="">Password</label>
                        <div class="password-wraper">
                            <input type="password" name="password" id="password" placeholder="**********************">
                            <i class="toggle-password fa fa-fw fa-eye-slash"></i>
                        </div>

                        <div class="flex-box">
                            <div class="checkbox">
                                <input type="checkbox" name="remember_me" id="remember_me" checked>
                                <label for="">Remember Me</label>
                            </div>
                            <a href="<?php echo get_site_url(); ?>/forgot-password">Forgot Password?</a>
                        </div>

                        <input type="submit" id="loginbtn" value="Log In" class="green-btn">

                    </form>

                    <div id="succ_msg" style="color:#9FCC3B;margin-bottom: 20px;"></div>
                    <div id="error_msg" style="color:Red;margin-bottom: 20px;"></div>


                    <p>Don’t have an account? Sign Up <a href="<?php echo get_site_url(); ?>/sign-up">Sign Up</a></p>
                </div>
            </div>
            <div class="col-lg-6 col-md-5">
                <?php 
                    $image = get_field('login_page_image', 'option'); 
                    $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                ?>

                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="login-img">
            </div>
        </div>
    </div>
</section>





<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.js"></script>

<script>
// Function to handle login process

function loginUser() {
    var userName = jQuery('#username').val();
    var userPassword = jQuery('#password').val();
    
    jQuery.ajax({
        type: "POST",
        dataType: 'json',
        url: "<?php echo admin_url('admin-ajax.php'); ?>",
        data: {
            action: "user_log_in",
            user_login: userName,
            user_password: userPassword
        },
        success: function(data) {
            if (data.loggedin == true) {
                jQuery('#error_msg').text(data.message).hide();
                jQuery('#succ_msg').text(data.succmessage).show();
                window.location.href = data.redirecturl;
            } else {
                jQuery('#error_msg').text(data.message).show();
                jQuery('#succ_msg').text(data.succmessage).hide();
            }
        },
        error: function(data) {

        }
    });
}


//remember me
jQuery(document).ready(function() {
    // Check if username is stored in localStorage and populate the input field
    var rememberedUsername = localStorage.getItem('rememberedUsername');
    var rememberedPassword = localStorage.getItem('rememberedPassword');

    if (rememberedUsername && rememberedPassword) {
        jQuery('#username').val(rememberedUsername);
        jQuery('#password').val(rememberedPassword);
        jQuery('#remember_me').prop('checked', true);
    }

    // Handle "Remember me" functionality
    jQuery('#remember_me').change(function() {
        if (jQuery(this).is(':checked')) {
            localStorage.setItem('rememberedUsername', jQuery('#username').val());
            localStorage.setItem('rememberedPassword', jQuery('#password').val());
        } else {
            localStorage.removeItem('rememberedUsername');
            localStorage.removeItem('rememberedPassword');
        }
    });

    // Handle login button click
    jQuery('#loginbtn').on('click', function(e) {
        e.preventDefault();
        loginUser();
    });
});


</script>


<?php
get_footer();
?>

