<?php
/**
* Template Name: Name Badge
*
*/

get_header();

?>


<section class="inner-banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1><?php echo get_the_title(); ?></h1>
                <ul>
                    <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                    <li><?php echo get_the_title(); ?></li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="desk-plate-sec3">
    <?php if(have_rows('section_1')) : ?>
    <?php while(have_rows('section_1')) : the_row(); ?>

    <div class="container">
        <div class="row align-items-lg-center">
            <div class="col-lg-6 col-md-5">
                <?php 
                    $image = get_sub_field('image'); 
                    $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                ?>

                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="site-img">
            </div>
            <div class="col-lg-6 col-md-7">

                <?php echo get_sub_field('content'); ?>

                <?php 
                    $button = get_sub_field('button'); 
                    if( $button ): 
                        $link_url = $button['url'];
                        $link_title = $button['title']; 
                        $link_target = $button['target'] ? $button['target'] : '_self'; 
                ?>
                <a href="<?php echo esc_url(  $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="green-btn"><?php echo esc_html( $link_title ); ?></a>
                <?php endif; ?>

            </div>
        </div>
    </div>

    <?php endwhile; endif; ?>
</section>

<section class="desk-plate-sec2">
    <?php if(have_rows('section_2')) : ?>
    <?php while(have_rows('section_2')) : the_row(); ?>

    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 col-md-7">

                <?php echo get_sub_field('content'); ?>                
                
                <div class="grid-box">

                    <?php if(have_rows('points')) : ?>
                    <?php while(have_rows('points')) : the_row(); ?>

                    <div class="grid-content">
                        <?php echo get_sub_field('point'); ?>
                    </div>

                    <?php endwhile; endif; ?>
                </div>
            </div>
            <div class="col-lg-5 col-md-5 ms-auto">
                <?php 
                    $image = get_sub_field('image'); 
                    $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                ?>

                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="main-img">
            </div>
        </div>
    </div>

    <?php endwhile; endif; ?>
</section>

<section class="desk-plate-sec3">
    <div class="container">

        <?php if(have_rows('zigzag_section')) : ?>
        <?php while(have_rows('zigzag_section')) : the_row(); ?>

        <div class="row align-items-center">
            <div class="col-lg-6 col-md-5">
                <?php 
                    $image = get_sub_field('image'); 
                    $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                ?>

                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="site-img">
            </div>
            <div class="col-lg-6 col-md-7">

                <?php echo get_sub_field('content'); ?>
                
                <?php 
                    $button = get_sub_field('button'); 
                    if( $button ): 
                        $link_url = $button['url'];
                        $link_title = $button['title']; 
                        $link_target = $button['target'] ? $button['target'] : '_self'; 
                ?>
                <a href="<?php echo esc_url(  $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="green-btn"><?php echo esc_html( $link_title ); ?></a>
                <?php endif; ?>
            </div>
        </div>

        <?php endwhile; endif; ?>

    </div>
</section>

<section class="name-badge-sec1">
    <?php if(have_rows('last_section')) : ?>
    <?php while(have_rows('last_section')) : the_row(); ?>

    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <?php echo get_sub_field('content'); ?>
            </div>

            <?php if(have_rows('products')) : ?>
            <?php while(have_rows('products')) : the_row(); ?>

            <div class="col-lg-3 col-md-4">
                <div class="badges-cart">
                    <h4><?php echo get_sub_field('name'); ?></h4>
                    <?php 
                        $image = get_sub_field('image'); 
                        $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                    ?>

                    <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="badge">
                </div>
            </div>

            <?php endwhile; endif; ?>

            <div class="col-lg-12">
                <?php 
                    $button = get_sub_field('button'); 
                    if( $button ): 
                        $link_url = $button['url'];
                        $link_title = $button['title']; 
                        $link_target = $button['target'] ? $button['target'] : '_self'; 
                ?>
                <a href="<?php echo esc_url(  $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="green-btn"><?php echo esc_html( $link_title ); ?></a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php endwhile; endif; ?>
</section>



<?php
get_footer();
?>
