<?php $args = array(
    'post_type' => 'product',
    'posts_per_page' => 12,
    'tax_query' => array(
        array(
            'taxonomy' => 'product_type',
            'field'    => 'slug',
            'terms'    => 'customize_product',
        ),
    ),
);

$loop = new WP_Query($args);

?>
<?php if ($loop->have_posts()) :?>
<section class="home-sec3">
    <div class="container">
        <div class="row">
            <?php 
            while ($loop->have_posts()) : $loop->the_post();
            global $product;
            // Get ACF image (returns image array or URL depending on settings)
            $small_image = get_field('small_image');
            // If it's a URL:
            $image_url = is_array($small_image) ? $small_image['url'] : $small_image;
            ?>
            <div class="col-lg-4 col-md-4">
                <div class="badges-cart">
                    <h4><?php the_title(); ?></h4>

                    <?php if ($image_url) : ?>
                        <img src="<?php echo esc_url($image_url); ?>" alt="<?php the_title_attribute(); ?>" class="badge">
                    <?php else : ?>
                        <img src="<?php echo get_template_directory_uri(); ?>/images/b4.png" alt="Default Image" class="badge">
                    <?php endif; ?>

                    <a href="<?php echo esc_url(get_permalink()); ?>" class="green-btn">Order Now</a>

                    <div class="hover-box">
                        <p><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                    </div>
                </div>
            </div>
            <?php
            endwhile;?>
           
        </div>
    </div>
</section>
<?php else : ?>
    <p><?php esc_html_e('No products found', 'woocommerce'); ?></p>
<?php wp_reset_postdata();?>
<?php endif; ?>