<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>

	<?php
		/**
		 * woocommerce_before_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */
		// do_action( 'woocommerce_before_main_content' );
	?>

		<?php while ( have_posts() ) : ?>
			<?php the_post(); ?>

			<?php wc_get_template_part( 'content', 'single-product' ); ?>

		<?php endwhile; // end of the loop. ?>

	<?php
		/**
		 * woocommerce_after_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );
	?>

	<?php
		/**
		 * woocommerce_sidebar hook.
		 *
		 * @hooked woocommerce_get_sidebar - 10
		 */
		// do_action( 'woocommerce_sidebar' );
	?>


<section class="about-sec2">
    <div class="container">
        <div class="row">
            <div class="col-lg-3 col-md-6">
                <div class="cart-wraper">
                    <img src="<?php echo get_template_directory_uri() ?>/images/a-icon1.svg" alt="">
                    <h4>Free Shipping</h4>
                    <p>We are happy to offer international shipping for a flat rate of $40.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="cart-wraper">
                    <img src="<?php echo get_template_directory_uri() ?>/images/a-icon2.svg" alt="">
                    <h4>Customization</h4>
                    <p>Pair text with an image to focus on your chosen product.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="cart-wraper">
                    <img src="<?php echo get_template_directory_uri() ?>/images/a-icon3.svg" alt="">
                    <h4>Easy Returns</h4>
                    <p>Pair text with an image to focus on your chosen product.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="cart-wraper">
                    <img src="<?php echo get_template_directory_uri() ?>/images/a-icon4.svg" alt="">
                    <h4>One Year Warranty</h4>
                    <p>Pair text with an image to focus on your chosen product.</p>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="desk-plate-sec3">
    <div class="container">
        <div class="row align-items-lg-center">
            <div class="col-lg-6 col-md-5">
                <img src="<?php echo get_template_directory_uri() ?>/images/site-img4.png" alt="" class="site-img">
            </div>
            <div class="col-lg-6 col-md-7">
                <h2>The Pin Badge - THE Classic Button Badge</h2>
                <p>Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. Morbi eget nunc accumsan, bibendum sem sit amet iaculis quis varius vel. Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. Morbi eget nunc accumsan, bibendum sem sit amet iaculis quis varius vel.Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. </p>
                <p>Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. Morbi eget nunc accumsan, bibendum sem sit amet iaculis quis varius vel..</p>
                <a href="#?" class="green-btn">Design Now</a>
            </div>
        </div>
        <div class="row align-items-lg-center">
            <div class="col-lg-6 col-md-5">
                <img src="<?php echo get_template_directory_uri() ?>/images/site-img5.png" alt="" class="site-img">
            </div>
            <div class="col-lg-6 col-md-7">
                <h2>Your Source for High-Quality Pin Badges</h2>
                <p>Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. Morbi eget nunc accumsan, bibendum sem sit amet iaculis quis varius vel. Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. Morbi eget nunc accumsan, bibendum sem sit amet iaculis quis varius vel.Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. </p>
                <p>Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. Morbi eget nunc accumsan, bibendum sem sit amet iaculis quis varius vel.</p>
                <a href="#?" class="green-btn">Design Now</a>
            </div>
        </div>
    </div>
</section>

<section class="name-badge-details-sec2">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h2>Testimonials</h2>
                <div class="owl-carousel owl-theme review-slider">
                    <div class="item">
                        <h5>John Smith</h5>
                        <h6>17 March, 2023</h6>
                        <ul>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                        </ul>
                        <p>Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. Morbi eget nunc accumsan, bibendum sem sit amet iaculis quis varius vel. bibendum sem sit amet iaculis quis varius vel bibendum.</p>
                    </div>
                    <div class="item">
                        <h5>John Smith</h5>
                        <h6>17 March, 2023</h6>
                        <ul>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                        </ul>
                        <p>Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. Morbi eget nunc accumsan, bibendum sem sit amet iaculis quis varius vel. bibendum sem sit amet iaculis quis varius vel bibendum.</p>
                    </div>
                    <div class="item">
                        <h5>John Smith</h5>
                        <h6>17 March, 2023</h6>
                        <ul>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                        </ul>
                        <p>Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. Morbi eget nunc accumsan, bibendum sem sit amet iaculis quis varius vel. bibendum sem sit amet iaculis quis varius vel bibendum.</p>
                    </div>
                    <div class="item">
                        <h5>John Smith</h5>
                        <h6>17 March, 2023</h6>
                        <ul>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                            <li><img src="<?php echo get_template_directory_uri() ?>/images/star.svg" alt=""></li>
                        </ul>
                        <p>Vivamus nisi arcu, iaculis quis varius vel, mattis a justo. Morbi eget nunc accumsan, bibendum sem sit amet iaculis quis varius vel. bibendum sem sit amet iaculis quis varius vel bibendum.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="faq-sec1">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h2>Frequently Asked Questions</h2>

                <ul class="accordian">
                    <li>
                        <h5>How do I order custom pin badges?</h5>
                        <div class="content">
                            <p>Aenean in mauris pharetra, suscipit arcu id, feugiat turpis. Maecenas et aliquet felis. Pellentesque cursus libero vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus. vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus..</p>
                        </div>
                    </li>
                    <li>
                        <h5>What types of pin badges do you offer?</h5>
                        <div class="content">
                            <p>Aenean in mauris pharetra, suscipit arcu id, feugiat turpis. Maecenas et aliquet felis. Pellentesque cursus libero vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus. vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus..</p>
                        </div>
                    </li>
                    <li>
                        <h5>How long does it take to receive my custom badges?</h5>
                        <div class="content">
                            <p>Aenean in mauris pharetra, suscipit arcu id, feugiat turpis. Maecenas et aliquet felis. Pellentesque cursus libero vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus. vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus..</p>
                        </div>
                    </li>
                    <li>
                        <h5>Can you help with the design process?</h5>
                        <div class="content">
                            <p>Aenean in mauris pharetra, suscipit arcu id, feugiat turpis. Maecenas et aliquet felis. Pellentesque cursus libero vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus. vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus..</p>
                        </div>
                    </li>
                    <li>
                        <h5>What file formats do you accept for custom designs?</h5>
                        <div class="content">
                            <p>Aenean in mauris pharetra, suscipit arcu id, feugiat turpis. Maecenas et aliquet felis. Pellentesque cursus libero vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus. vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus..</p>
                        </div>
                    </li>
                    <li>
                        <h5>What are the pricing options for custom badges?</h5>
                        <div class="content">
                            <p>Aenean in mauris pharetra, suscipit arcu id, feugiat turpis. Maecenas et aliquet felis. Pellentesque cursus libero vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus. vel arcu hendrerit feugiat. Donec ullamcorper vel lorem eu maximus..</p>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</section>

<?php
get_footer( 'shop' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
