<?php /* Template Name: Common Page */
get_header(); ?>

 <section class="innerBanner">
   <?php $commonbannerimg = get_field('banner_image');
    if (!empty($commonbannerimg)) {
        $alt_text = !empty($commonbannerimg['alt']) ? $commonbannerimg['alt'] : $commonbannerimg['title']; ?>
        <img src="<?php echo esc_url($commonbannerimg['url']); ?>" class="banner-img" alt="<?php echo esc_attr($alt_text); ?>">
    <?php } else { ?>
        <img class="banner-img" src="<?php echo get_template_directory_uri(); ?>/images/inner_banner_abt.png" alt="banner-img">
    <?php } ?>
    <div class="bannerTxt aos-init aos-animate" data-aos="fade-up">
        <div class="container">
            <div class="row">
                <div class="col-md-8 m-auto">
                    <h1><?php the_title(); ?></h1>
                    <div class="breadCrumb">
                        <ul>
                            <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                            <li><?php the_title(); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="about-us sectiondefaultspacing">
    <div class="container">
    	<div class="row">
    		<div class="col-md-12">
    			<?php the_content(); ?>
    		</div>
    	</div>
    </div>
</section>

<?php get_footer(); ?>