<?php /* Template Name: Service */
get_header();
 ?>

<!-- ! Main ! -->
<section class="innerBanner">
   <?php $commonbannerimg = get_field('banner_image');
    if (!empty($commonbannerimg)) {
        $alt_text = !empty($commonbannerimg['alt']) ? $commonbannerimg['alt'] : $commonbannerimg['title']; ?>
        <img src="<?php echo esc_url($commonbannerimg['url']); ?>" class="banner-img" alt="<?php echo esc_attr($alt_text); ?>">
    <?php } else { ?>
        <img class="banner-img" src="<?php echo get_template_directory_uri(); ?>/images/inner_banner_abt.png" alt="banner-img">
    <?php } ?>
    <div class="bannerTxt aos-init aos-animate" data-aos="fade-up">
        <div class="container">
            <div class="row">
                <div class="col-md-8 m-auto">
                    <h1><?php the_title(); ?></h1>
                    <div class="breadCrumb">
                        <ul>
                            <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                            <li><?php the_title(); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="serSec1 sectiondefaultspacing">
    <div class="container">
        <div class="row align-items-lg-center eachNumber">
            <div class="col-lg-6">
                <div class="groupCircle_services">
                    <?php $count = 0;
                    $circlegrplist = get_field('service_group_circle_list');
                        if ($circlegrplist) {
                            foreach ($circlegrplist as $circlegrpitem){ 
                                 // Get the image (assumed to be ACF image field stored as array)
                                $circlegrpicon = $circlegrpitem['service_group_circle_image']; // assuming 'icon_image' is your image field
                                if (!empty($circlegrpicon)) {
                                    $alt_text = !empty($circlegrpicon['alt']) ? $circlegrpicon['alt'] : $circlegrpicon['title']; ?>
                    <img src="<?php echo esc_url($circlegrpicon['url']); ?>" class="<?php if($count==0){ echo 'mainHouse'; } else{ echo 'eachImg'. $count; } ?>" alt="<?php echo esc_attr($alt_text); ?>">
                    <?php } $count++; } } ?>
                </div>
                <?php $sercotct = get_field('service_group_circle_button');
                        if ($sercotct):
                            $link_url = $sercotct['url'];
                            $link_title = $sercotct['title'];
                            $link_target = $sercotct['target'] ? $sercotct['target'] : '_self'; ?>
                            <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="btn"><?php echo esc_html($link_title); ?></a>
                            <?php endif; ?>
            </div>
            <?php if( have_rows('circle_service_list') ):
            while( have_rows('circle_service_list') ) : the_row(); ?>
            <div class="col-lg-3 col-md-6">
                <?php if( have_rows('circle_service_row_list') ):
            while( have_rows('circle_service_row_list') ) : the_row(); ?>
                <div class="serItem">
                    <div class="counterEach"></div>
                    <h3><?php echo get_sub_field('circle_service_title'); ?></h3>
                    <p><?php echo get_sub_field('circle_service_content'); ?></p>
                </div>
                <?php endwhile; endif; ?>
            </div>
        <?php endwhile; endif; ?>
        </div>
    </div>
</section>
<?php if(get_field('short_process_heading',7) || get_field('short_process_step',7)){ ?>
<section class="shortprocess sectiondefaultspacing">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-lg-7 col-md-6">
                <?php $processimg = get_field('short_process_image',7);
            if (!empty($processimg)) {
                $alt_text = !empty($processimg['alt']) ? $processimg['alt'] : $processimg['title']; ?>
                <div class="img">
                    <img src="<?php echo esc_url($processimg['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div><?php } ?>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="text">
                    <?php if(get_field('short_process_heading',7)){ ?>
                    <h2><?php echo get_field('short_process_heading',7); ?></h2>
                    <?php } ?>
                    <ul>
                        <?php $processstep = get_field('short_process_step',7);
                        if ($processstep) {
                            foreach ($processstep as $processsitem) { ?>
                        <li>
                            <h6><?php echo $processsitem['short_process_step_title']; ?></h6>
                            <h4><?php echo $processsitem['short_process_step_content']; ?></h4>
                        </li>
                        <?php } } ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<?php $sergetlist = get_field('service_you_get_list');
if ($sergetlist) { ?>
<section class="hw_wrk_sec3 sectiondefaultspacing">
    <div class="container">
        <div class="roundBx_hw">
            <?php $whgetimage = get_field('service_you_get_bg_image');
            if (!empty($whgetimage)) {
                $alt_text = !empty($whgetimage['alt']) ? $whgetimage['alt'] : $whgetimage['title']; ?>
            <div class="bg_img">
                <img src="<?php echo esc_url($whgetimage['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
            </div><?php } ?>
            <div class="innerTxtHw">
                <?php if(get_field('service_you_get_heading')){ ?>
                <h2><?php echo get_field('service_you_get_heading'); ?></h2><?php } ?>
                <ul class="eachBx">
                    <?php foreach ($sergetlist as $sergetlistitem){ 
                                 // Get the image (assumed to be ACF image field stored as array)
                                $sergeticon = $sergetlistitem['service_you_get_icon']; // assuming 'icon_image' is your image field
                                if (!empty($sergeticon)) {
                                    $alt_text = !empty($sergeticon['alt']) ? $sergeticon['alt'] : $sergeticon['title']; ?>
                    <li>
                        <div class="hwWrk">
                            <div class="wrkIcon">
                                <img src="<?php echo esc_url($sergeticon['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                            </div>
                            <p><?php echo $sergetlistitem['service_you_get_content']; ?></p>
                        </div>
                    </li>
                <?php } } ?>
                </ul>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<section class="gettouch sectiondefaultspacing">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-md-5">
                <div class="text">
                    <?php if(get_field('contact_section_heading',7)){ ?>
                    <h2><?php echo get_field('contact_section_heading',7); ?></h2><?php } ?>
                    <?php if(get_field('contact_section_subheading',7)){ ?>
                    <p><?php echo get_field('contact_section_subheading',7); ?></p><?php } ?>

                    <div class="contacts">
                        <?php $phoneno = get_field('phone_number','option');
                        $tel_number = preg_replace('/\D/', '', $phoneno);
                        if($phoneno){ ?>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/phone-icon.png" alt="">
                            </div>
                            <div class="ic-text">
                                <h6>Call Us</h6>
                                <p>
                                    <a href="tel:<?php echo $tel_number; ?>"><?php echo $phoneno; ?></a>
                                </p>
                            </div>
                        </div><?php } ?>
                        <?php if(get_field('email','option')) { ?>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/mail-icon.png" alt="">
                            </div>
                            <div class="ic-text">
                                <h6>Email Us</h6>
                                <p><a href="mailto:<?php echo get_field('email','option'); ?>"><?php echo get_field('email','option'); ?></a></p>
                            </div>
                        </div><?php } ?>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="formarea">
                    <h3>Contact Us</h3>
                    <?php echo do_shortcode('[contact-form-7 id="eee4220" title="Home Contact Form"]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ! Main end ! -->

<?php get_footer(); ?>