<?php

if ( ! isset( $content_width ) )
	$content_width = 604;

function admin_bar(){

  if(is_user_logged_in()){
    add_filter( 'show_admin_bar', '__return_true' , 1000 );
  }
}
add_action('init', 'admin_bar' );

function smtheme_setup() {

	register_nav_menu( 'primary', __( 'Primary Menu', 'smtheme' ) );
    register_nav_menu( 'footer', __( 'Footer Menu', 'smtheme' ) );
	register_nav_menu( 'legal1', __( 'Legal 1 Menu', 'smtheme' ) );
    register_nav_menu( 'legal2', __( 'Legal 2 Menu', 'smtheme' ) );


 	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
    add_image_size( 'team', 356, 341, true );





	//set_post_thumbnail_size( 604, 270, true );
}
add_action( 'after_setup_theme', 'smtheme_setup' );



function smtheme_wp_title( $title, $sep ) {
	global $paged, $page;
	if ( is_feed() )
		return $title;
	$title .= get_bloginfo( 'name', 'display' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";
	if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'smtheme_wp_title' ), max( $paged, $page ) );
	return $title;
}
add_filter( 'wp_title', 'smtheme_wp_title', 10, 2 );



function smtheme_scripts_styles() {
  wp_enqueue_style( 'smtheme-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'smtheme-style', get_stylesheet_uri(), array(), '2025-09-09' );
	
}
add_action( 'wp_enqueue_scripts', 'smtheme_scripts_styles' );



function mytheme_enqueue_scripts() {
    // =====================
    //  CSS
    // =====================
    wp_enqueue_style('fontawesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css', array(), '6.4.2');
    wp_enqueue_style('bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css', array(), '5.2.3');
    wp_enqueue_style('swiper', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css', array(), '11');
    wp_enqueue_style('jquery-ui', 'https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css', array(), '1.13.2');
    wp_enqueue_style('aos', 'https://unpkg.com/aos@2.3.1/dist/aos.css', array(), '2.3.1');
    wp_enqueue_style('stellarnav', get_template_directory_uri() . '/css/stellarnav.css', array(), '1.0');
    wp_enqueue_style('lity', get_template_directory_uri() . '/css/lity.css', array(), '1.0');
    wp_enqueue_style('theme-style', get_template_directory_uri() . '/css/style.css', array(), '1.0');
    wp_enqueue_style('theme-responsive', get_template_directory_uri() . '/css/responsive.css', array('theme-style'), '1.0');

    // =====================
    //  JS
    // =====================
    // WordPress' built-in jQuery
    wp_enqueue_script('jquery'); 

    // Bootstrap (depends on jQuery)
    wp_enqueue_script('bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js', array('jquery'), '5.2.3', true);

    // Swiper
    wp_enqueue_script('swiper', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js', array(), '11', true);

    // jQuery UI (already bundled in WP, no need for external)
    wp_enqueue_script('jquery-ui-core');
    wp_enqueue_script('jquery-ui-datepicker'); // ✅ REQUIRED for .datepicker()
    wp_enqueue_script('jquery-ui-tabs'); // example, enqueue specific components if needed

    // AOS
    wp_enqueue_script('aos', 'https://unpkg.com/aos@2.3.1/dist/aos.js', array(), '2.3.1', true);

    // Custom JS files (from theme)
    wp_enqueue_script('stellarnav', get_template_directory_uri() . '/js/stellernav.js', array('jquery'), '1.0', true);
    wp_enqueue_script('equalheight', get_template_directory_uri() . '/js/equalheight.js', array('jquery'), '1.0', true);
    wp_enqueue_script('theme-app', get_template_directory_uri() . '/js/app.js', array('jquery'), '1.0', true);
}
add_action('wp_enqueue_scripts', 'mytheme_enqueue_scripts');






function custom_excerpt_length($length) {
    return 30;
}
add_filter('excerpt_length', 'custom_excerpt_length');




//Upload SVG images
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
    $filetype = wp_check_filetype( $filename, $mimes );
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
  }
  add_action( 'admin_head', 'fix_svg' );


  // Remove <p> and <br/> from Contact Form 7
add_filter('wpcf7_autop_or_not', '__return_false');


//--------service post type------------

Function post_type_our_service() {

$labels = array(
'name' => _x('Services', 'plural'),
'singular_name' => _x('Service', 'singular'),
'menu_name' => _x('Services', 'admin menu'),
'name_admin_bar' => _x('Service', 'admin bar'),
'add_new' => _x('Add New', 'add new'),
'add_new_item' => __('Add New Service'),
'new_item' => __('New Service'),
'edit_item' => __('Edit Service'),
'view_item' => __('View Service'),
'all_items' => __('All Services'),

);
$args = array(
'supports' => array( 'title',  'thumbnail', 'editor',),
'labels' => $labels,
'public' => true,
'query_var' => true,
'rewrite' => array('slug' => 'our_service'),
'has_archive' => true,
'hierarchical' => false,
);
register_post_type('our_service', $args);
}
add_action('init', 'post_type_our_service');



