<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
	<meta name="format-detection" content="telephone=no, address=no, email=no, date=no"> 
    <title><?php wp_title( '|', true, 'right' ); ?></title>
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div class="overlayBg"></div>

    <header class="header_main">
        <div class="container">
            <div class="d_flex">
                <?php $hlogo = get_field('header_logo','option');
                if (!empty($hlogo)) {
                $alt_text = !empty($hlogo['alt']) ? $hlogo['alt'] : $hlogo['title']; ?>
                <div class="logo">
                    <a href="<?php echo get_site_url(); ?>"><img src="<?php echo esc_url($hlogo['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>" class="normal"></a>
                </div>
                <?php } ?>
                <div class="stellarnav">
                    <?php wp_nav_menu( array('menu' => 'Header_Menu', 'container' => '', 'items_wrap' => '<ul class="">%3$s</ul>' )); ?>
                </div>
                <?php $contlink = get_field('contact_us_button_link','option');
                        if ($contlink):
                            $link_url = $contlink['url'];
                            $link_title = $contlink['title'];
                            $link_target = $contlink['target'] ? $contlink['target'] : '_self'; ?>
                <div class="rig_btn">
                    <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="btn"><?php echo esc_html($link_title); ?></a>
                </div>
            <?php endif; ?>
            </div>
        </div>
    </header>