jQuery(document).ready(function () {
  //-------------------------------------------------------
  // 1. StellarNav Menu
  //-------------------------------------------------------
  jQuery(".stellarnav").stellarNav({
    breakpoint: 991,
    position: "right",
  });

  //-------------------------------------------------------
  // 2. FAQ Toggle on Home Page
  //-------------------------------------------------------
  jQuery(".faq_box").each(function () {
    jQuery(this).on("click", ".acc_trigger", function (e) {
      e.preventDefault();

      const $trigger = jQuery(this);
      const $item = $trigger.closest(".faq_item");
      const $container = $item.find(".acc_container");
      const $box = $trigger.closest(".faq_box");

      if ($container.is(":visible")) {
        $container.slideUp(300);
        $trigger.removeClass("active closed");
        $item.removeClass("main_active");
      } else {
        $box.find(".acc_container").slideUp(300);
        $box.find(".acc_trigger").removeClass("active closed");
        $box.find(".faq_item").removeClass("main_active");

        $container.slideDown(300);
        $trigger.addClass("active closed");
        $item.addClass("main_active");
      }
    });
  });

  //-------------------------------------------------------
  // 3. Password Toggle (Eye Icon)
  //-------------------------------------------------------
  jQuery(".inpt-password i").on("click", function () {
    const $icon = jQuery(this);
    const $input = $icon.siblings("input");
    const type = $input.attr("type") === "password" ? "text" : "password";

    $input.attr("type", type);
    $icon.toggleClass("fa-eye fa-eye-slash");
  });

  //-------------------------------------------------------
  // 4. Counter Animation on Scroll
  //-------------------------------------------------------
  let counted = {};

  jQuery(window).on("scroll", function () {
    jQuery(".counter").each(function (index) {
      const $counter = jQuery(this);
      const oTop = $counter.offset().top - window.innerHeight;

      // Give each counter a unique key (like index)
      if (!counted[index] && jQuery(window).scrollTop() > oTop) {
        $counter.find(".count").each(function () {
          const $this = jQuery(this);
          const countTo = $this.attr("data-count");

          jQuery({ countNum: $this.text() }).animate(
            { countNum: countTo },
            {
              duration: 2000,
              easing: "swing",
              step: function () {
                $this.text(Math.floor(this.countNum));
              },
              complete: function () {
                $this.text(this.countNum);
              },
            }
          );
        });

        counted[index] = true; // mark this counter section as done
      }
    });
  });

  //-------------------------------------------------------//
  // change image by tab js
  //-------------------------------------------------------//

  const $loginImage = jQuery(".imgRound img");

  jQuery('button[data-bs-toggle="pill"]').on("shown.bs.tab", function (e) {
    const target = jQuery(e.target).data("bs-target");

    if (target === "#pills-general") {
      $loginImage.attr("src", $loginImage.data("img-general"));
    } else if (target === "#pills-train") {
      $loginImage.attr("src", $loginImage.data("img-train"));
    } else if (target === "#pills-tchPrgm") {
      $loginImage.attr("src", $loginImage.data("img-tchprgm"));
    } else if (target === "#pills-kids") {
      $loginImage.attr("src", $loginImage.data("img-kids"));
    }
  });
  //-------------------------------------------------------//
  // change image by tab js end
  //-------------------------------------------------------//

  jQuery("#date_pre").datepicker({
    dateFormat: "dd-mm-yy",
  });
});

// ! add Swiper there
document.addEventListener("DOMContentLoaded", function () {
  // ! swiper testimonials
  var swiper = new Swiper(".portfolioSwiper", {
    spaceBetween: 20,
    centeredSlides: true,
    autoHeight: true, // ✅ Enables dynamic height
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
  });
});
