<?php /* Template Name: Contact */
get_header();
?>


<!-- ! Main ! -->

<section class="hm_banner innerBanner" id="home">
    <div class="middle_caption">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="innerTxt">
                        <h1><?php the_title(); ?></h1>
                        <ul class="breadCrumb">
                            <li><a href="<?php get_site_url(); ?>">Home</a></li>
                            <li><?php the_title(); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="stroke_dots one"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke1.png" alt="stroke-line"></div>
    <div class="stroke_dots two"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke2.png" alt="stroke-line"></div>
    <div class="stroke_dots three"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke3.png" alt="stroke-line"></div>
    <div class="stroke_dots four"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke4.png" alt="stroke-line"></div>
</section>

<section class="cntPg defaultPadding">
    <div class="container">
        <div class="row flex-md-row-reverse align-items-md-stretch">
            <div class="col-md-6">
                <?php if(get_field('contact_tab_image_1')){ ?>
                <div class="imgRound">
                    <img src="<?php echo get_field('contact_tab_image_1'); ?>" 
                        alt="img" 
                        data-img-general="<?php echo get_field('contact_tab_image_1'); ?>"
                        data-img-train="<?php echo get_field('contact_tab_image_2'); ?>"
                        data-img-tchPrgm="<?php echo get_field('contact_tab_image_3'); ?>"
                        data-img-kids="<?php echo get_field('contact_tab_image_4'); ?>">
                </div><?php } ?>
            </div>
            <div class="col-md-6">
                 <?php if(get_field('contact_form_heading')){ ?>
                    <h2><?php echo get_field('contact_form_heading'); ?></h2>
                <?php } ?>
                <?php if(get_field('contact_form_subheading')){ ?>
                <h4><?php echo get_field('contact_form_subheading'); ?></h4><?php } ?>
                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                    <?php if(get_field('contact_tab_text_1')){ ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="pills-general-tab" data-bs-toggle="pill" data-bs-target="#pills-general" type="button" role="tab" aria-controls="pills-general" aria-selected="true"><?php echo get_field('contact_tab_text_1'); ?></button>
                    </li><?php } ?>
                    <?php if(get_field('contact_tab_text_2')){ ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-train-tab" data-bs-toggle="pill" data-bs-target="#pills-train" type="button" role="tab" aria-controls="pills-train" aria-selected="false"><?php echo get_field('contact_tab_text_2'); ?></button>
                    </li><?php } ?>
                    <?php if(get_field('contact_tab_text_3')){ ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-tchPrgm-tab" data-bs-toggle="pill" data-bs-target="#pills-tchPrgm" type="button" role="tab" aria-controls="pills-tchPrgm" aria-selected="false"><?php echo get_field('contact_tab_text_3'); ?></button>
                    </li><?php } ?>
                    <?php if(get_field('contact_tab_text_4')){ ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-kids-tab" data-bs-toggle="pill" data-bs-target="#pills-kids" type="button" role="tab" aria-controls="pills-kids" aria-selected="false"><?php echo get_field('contact_tab_text_4'); ?></button>
                    </li><?php } ?>
                </ul>
                


                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="pills-general" role="tabpanel" aria-labelledby="pills-general-tab" tabindex="0">
                        <div class="allFill one">
                            <?php echo do_shortcode('[contact-form-7 id="8393a95" title="General Form"]'); ?>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-train" role="tabpanel" aria-labelledby="pills-train-tab" tabindex="0">
                        <div class="allFill two">
                            <?php echo do_shortcode('[contact-form-7 id="10e8605" title="Training Program"]'); ?>
                            <!-- <form action="">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Full Name</label>
                                            <input type="text" placeholder="John">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Email</label>
                                            <input type="email" placeholder="johnsmith@gmail.com">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Company (optional)</label>
                                            <input type="text" placeholder="NousOnWork Technologies">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Number of participants</label>
                                            <input type="number" placeholder="02">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <label>Training topic of interest</label>
                                            <input type="text">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <label>Preferred dates</label>
                                            <input type="text" id="date_pre" placeholder="12/09/2025">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <label>Training format preference</label>
                                            <select name="" id="">
                                                <option value="">Hybrid</option>
                                                <option value="">1</option>
                                                <option value="">2</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <label>Special requirements</label>
                                            <input type="text" placeholder="Hybrid">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <input type="submit" value="Submit" class="btn">
                                        </div>
                                    </div>
                                </div>
                            </form> -->
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-tchPrgm" role="tabpanel" aria-labelledby="pills-tchPrgm-tab" tabindex="0">
                        <div class="allFill three">
                            <?php echo do_shortcode('[contact-form-7 id="690a397" title="Technology Solution"]'); ?>
                            <!-- <form action="">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Full Name</label>
                                            <input type="text" placeholder="John Smith">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Email</label>
                                            <input type="email" placeholder="johnsmith@gmail.com">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Company (optional)</label>
                                            <input type="text" placeholder="NousOnWork Technologies">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Timeline</label>
                                            <input type="number" placeholder="15 Days">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <label>Budget ranget</label>
                                            <input type="text" placeholder="$200 - $500">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <label>Technical requirements</label>
                                            <select name="" id="">
                                                <option value="">Laptop</option>
                                                <option value="">1</option>
                                                <option value="">2</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <label>Project description</label>
                                            <textarea placeholder="Type here..."></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <input type="submit" value="Submit" class="btn">
                                        </div>
                                    </div>
                                </div>
                            </form> -->
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-kids" role="tabpanel" aria-labelledby="pills-kids-tab" tabindex="0">
                        <div class="allFill four">
                            <?php echo do_shortcode('[contact-form-7 id="0628df1" title="Kids Program"]'); ?>
                            <!-- <form action="">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Parent/Guardian name</label>
                                            <input type="text" placeholder="John Smith">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Email</label>
                                            <input type="email" placeholder="johnsmith@gmail.com">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Phone</label>
                                            <input type="tel" placeholder="+01-852-652-325">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="inputGrp">
                                            <label>Child's name and age</label>
                                            <input type="text" placeholder="Alex, 15 year">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <label>Program of interest</label>
                                            <input type="text">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <label>Previous experience</label>
                                            <input type="text" placeholder="Project manager">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <label>Special needs/accommodations</label>
                                            <input type="text">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="inputGrp">
                                            <input type="submit" value="Submit" class="btn">
                                        </div>
                                    </div>
                                </div>
                            </form> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>

<section class="cntPg2 defaultPadding80">
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <?php if(get_field('phone_number','option') || get_field('phone_number_2','option')){ ?>
                <div class="cntItem">
                    <div class="circleIcon"><img src="<?php echo get_template_directory_uri(); ?>/images/phoneIocn.svg" alt=""></div>
                    <h3>Give Us A Call</h3>
                    <p><a href="tel:+<?php echo get_field('phone_number','option'); ?>"><?php echo get_field('phone_number','option'); ?></a> <a href="tel:<?php echo get_field('phone_number_2','option'); ?>"><?php echo get_field('phone_number_2','option'); ?></a></p>
                </div><?php } ?>
            </div>
            <?php if(get_field('email','option')){ ?>
            <div class="col-md-4">
                <div class="cntItem">
                    <div class="circleIcon"><img src="<?php echo get_template_directory_uri(); ?>/images/emailIocn.svg" alt=""></div>
                    <h3>Send us an email</h3>
                    <p><a href="mailto:<?php echo get_field('email','option'); ?>"><?php echo get_field('email','option'); ?></a></p>
                </div>
            </div>
            <?php } ?>
            <?php if(get_field('address','option')){ ?>
            <div class="col-md-4">
                <div class="cntItem">
                    <div class="circleIcon"><img src="<?php echo get_template_directory_uri(); ?>/images/locationIocn.svg" alt=""></div>
                    <h3>Visit our office</h3>
                    <p><?php echo get_field('address','option'); ?></p>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</section>

<!-- ! Main end ! -->

<?php get_footer(); ?>