<?php $footer_short = get_field('footer_shortcontent','option');
$copyright_text = get_field('copyright_text','option'); ?>
    <footer>
    <img src="<?php echo get_template_directory_uri(); ?>/images/footer-shape.png" alt="footer-shape" class="shape-img">
    <div class="container">
        <div class="flex-wraper">
            <div class="left-content-wraper">
                <?php $footer_logo = get_field('footer_logo','option');
                    if (!empty($footer_logo)) {
                        $alt_text = !empty($footer_logo['alt']) ? $footer_logo['alt'] : $footer_logo['title']; ?>
                <a href="<?php echo get_site_url(); ?>" class="logo"><img src="<?php echo esc_url($footer_logo['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>"></a>
            <?php } else{ ?>
                <a href="<?php echo get_site_url(); ?>" class="logo"><img src="<?php echo get_template_directory_uri(); ?>/images/logo-footer.png" alt="logo-footer"></a>
            <?php } ?>
            <?php if($footer_short){ ?>
                <p><?php echo $footer_short; ?></p>
            <?php } ?>
            </div>
            <div class="right-content-wraper">
                <div class="menu-item">
                    <h5>Quick Links</h5>
                    <?php wp_nav_menu( array('menu' => 'Footer_Menu', 'container' => '', 'items_wrap' => '<ul class="menu">%3$s</ul>' )); ?>
                </div>
                <div class="menu-item">
                    <?php $social_media = get_field('social_media_list','option');
                        if ($social_media) { ?>
                    <h5>Social Media</h5>
                    <ul class="social-icon">
                        <?php foreach ($social_media as $socialitem) { ?>
                        <li><a href="<?php echo $socialitem['social_media_link']; ?>" target="_blank"><?php echo $socialitem['social_media_icon']; ?></a></li>
                    <?php } ?>
                    </ul><?php } ?>
                </div>
            </div>
        </div>
        <?php if($copyright_text){ ?>
        <div class="copyright">
            <h6>Copyright © <?php echo date('Y'); ?> <?php echo $copyright_text; ?></h6>
        </div><?php } ?>
    </div>
</footer>

<?php wp_footer(); ?>
</body>

</html>