<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php wp_title( '|', true, 'right' ); ?></title>
    <?php wp_head(); ?>
</head>
<?php 
$email = get_field('email','option');
$phone = get_field('phone','option');
 ?>
<body <?php body_class(); ?>>
<header>
    <div class="header-top">
        <div class="container">
            <div class="flex-wraper">
                <?php if($email){ ?>
                <div class="mail-wraper">
                    <a href="mailto:<?php echo $email; ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/email.svg" alt="email"><?php echo $email; ?></a>
                    
                </div><?php } ?>
                <?php if($phone){ ?>
                <div class="number-wraper">
                    <a href="tel:<?php echo $phone; ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/phone.svg" alt="phone"><?php echo $phone; ?></a>
                </div><?php } ?>
            </div>
        </div>
    </div>
    <div class="header-bottom">
        <div class="container">
            <div class="flex-wraper">
                <div class="logo-wraper">
                    <?php $header_logo = get_field('header_logo','option');
                    if (!empty($header_logo)) {
                        $alt_text = !empty($header_logo['alt']) ? $header_logo['alt'] : $header_logo['title']; ?>
                    <a href="<?php echo get_site_url(); ?>"><img src="<?php echo esc_url($header_logo['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>"></a>
                    <?php } else {  ?>

                    <a href="<?php echo get_site_url(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/logo-header.png" alt="logo-header"></a>
                    <?php } ?>
                </div>
                <div id="navigation">
                    <nav>
                        <?php wp_nav_menu( array('menu' => 'Header_Menu', 'container' => '', 'items_wrap' => '<ul class="">%3$s</ul>' )); ?>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</header>