<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php wp_title( '|', true, 'right' ); ?></title>
    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <link rel="icon" href="favicon.ico" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/stellarnav.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/lity.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/style.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/responsive.css">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php $logo = get_field('logo', 'option');
$header_button = get_field('header_button', 'option'); ?>
    <header class="header_main">
        <div class="container">
            <div class="hd_adjust">
                <div class="logo">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <?php if(!empty($logo)){ ?><img src="<?php echo esc_url($logo['url']); ?>" alt="<?php echo esc_url($logo['alt']); ?>" ><?php }else{ ?><img src="<?php echo get_template_directory_uri(); ?>/assets/images/logo.png" alt="Logo"><?php } ?>
                    </a>

                </div>
                <div class="stellarnav">
                    <?php wp_nav_menu( array( 'theme_location' => 'primary', 'container' => '', 'menu_class' => '' ) ); ?>
                </div>
                <?php if( $header_button ): 
                    $link_url = $header_button['url'];
                    $link_title = $header_button['title']; ?>
                <div class="rig-btn">
                    <a href="<?php echo esc_url( $link_url ); ?>" class="btn"><?php echo esc_html( $link_title ); ?></a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </header>